/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.KDebug;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.Preferences;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Enumeration;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import sun.security.provider.PolicyParser;

public class PolicyTool {
    private static final KDebug db = new KDebug("PolicyTool");
    private static final String userPolicyFileName = System.getProperty("user.home") + File.separator + ".java.policy";
    private static final String sysPolicyFileName = System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "java.policy";
    private static final String LAUNCHER_CODEBASE = "http://*/fs/LAUNCHER.jar";
    private static final String PREF_PATH = "ctc.ignore.dialogs";
    private static final String PREF_PATH_DESC_EXTENSION = "description";
    private static final String PREF_PATH_VALUE_EXTENSION = "value";
    private static final String SHOW_POLICY_DIALOG = "showPolicyDialog";
    private static final String SHOW_POLICY_DIALOG_DESC = "Suggest removal of modified policy file";
    private static boolean showPolicyDialog = true;
    private static Preferences prefs = Preferences.instance();

    private PolicyTool() {
    }

    public static void run() {
        if (db.on()) {
            db.println("starting...");
        }
        PolicyParser policyParser = PolicyTool.loadPolicyFile(userPolicyFileName);
        PolicyParser policyParser2 = PolicyTool.loadPolicyFile(sysPolicyFileName);
        showPolicyDialog = prefs.getBoolean("ctc.ignore.dialogs.value", SHOW_POLICY_DIALOG, true);
        if (!showPolicyDialog) {
            return;
        }
        PolicyParser.GrantEntry grantEntry = PolicyTool.getLauncherGE(policyParser);
        if (grantEntry != null && PolicyTool.isOKToChangePolicy()) {
            db.println("policy in .java.policy");
            policyParser.remove(grantEntry);
            PolicyTool.savePolicyFile(userPolicyFileName, policyParser);
        }
        if ((grantEntry = PolicyTool.getLauncherGE(policyParser2)) != null && PolicyTool.isOKToChangePolicy()) {
            db.println("policy in system policy");
            policyParser2.remove(grantEntry);
            PolicyTool.savePolicyFile(sysPolicyFileName, policyParser2);
        }
        if (db.on()) {
            db.println("ending...");
        }
    }

    private static PolicyParser.GrantEntry getLauncherGE(PolicyParser policyParser) {
        PolicyParser.GrantEntry grantEntry = null;
        PolicyParser.PermissionEntry permissionEntry = new PolicyParser.PermissionEntry("java.security.AllPermission", null, null);
        if (policyParser == null) {
            return null;
        }
        Enumeration<PolicyParser.GrantEntry> enumeration = policyParser.grantElements();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                PolicyParser.GrantEntry grantEntry2 = enumeration.nextElement();
                if (grantEntry2.codeBase == null || !grantEntry2.codeBase.equals(LAUNCHER_CODEBASE) || grantEntry2.signedBy != null && !grantEntry2.signedBy.equals("") || !grantEntry2.contains(permissionEntry)) continue;
                grantEntry = grantEntry2;
            }
        }
        return grantEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static PolicyParser loadPolicyFile(String var0) {
        block20: {
            if (PolicyTool.db.on()) {
                PolicyTool.db.println("loading policy from " + var0);
            }
            var1_1 = new File(var0);
            var2_2 = new PolicyParser();
            if (var1_1.exists() && var1_1.canRead()) {
                var3_3 = null;
                try {
                    var3_3 = new FileReader(var1_1);
                    var2_2.read(var3_3);
                    var6_4 = null;
                    ** if (var3_3 == null) goto lbl-1000
                }
                catch (Throwable var5_17) {
                    var6_8 = null;
                    if (var3_3 != null) {
                        try {
                            var3_3.close();
                        }
                        catch (IOException var7_13) {
                            KDebug.printStackTrace(var7_13);
                        }
                    }
                    throw var5_17;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var3_3.close();
                    }
                    catch (IOException var7_9) {
                        KDebug.printStackTrace(var7_9);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block20;
                    catch (FileNotFoundException var4_14) {
                        KDebug.printStackTrace(var4_14);
                        var6_5 = null;
                        if (var3_3 != null) {
                            try {
                                var3_3.close();
                            }
                            catch (IOException var7_10) {
                                KDebug.printStackTrace(var7_10);
                            }
                        }
                        break block20;
                    }
                    catch (PolicyParser.ParsingException var4_15) {
                        KDebug.printStackTrace(var4_15);
                        var6_6 = null;
                        if (var3_3 != null) {
                            try {
                                var3_3.close();
                            }
                            catch (IOException var7_11) {
                                KDebug.printStackTrace(var7_11);
                            }
                        }
                        break block20;
                    }
                    catch (IOException var4_16) {
                        KDebug.printStackTrace(var4_16);
                        var6_7 = null;
                        if (var3_3 != null) {
                            try {
                                var3_3.close();
                            }
                            catch (IOException var7_12) {
                                KDebug.printStackTrace(var7_12);
                            }
                        }
                        break block20;
                    }
                }
            }
            return null;
        }
        if (PolicyTool.db.on()) {
            PolicyTool.db.println("load complete");
        }
        return var2_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void savePolicyFile(String var0, PolicyParser var1_1) {
        block13: {
            if (PolicyTool.db.on()) {
                PolicyTool.db.println("saving policy to " + var0);
            }
            var2_2 = null;
            try {
                var2_2 = new FileWriter(var0);
                var1_1.write(var2_2);
                var5_3 = null;
                ** if (var2_2 == null) goto lbl-1000
            }
            catch (Throwable var4_10) {
                var5_5 = null;
                if (var2_2 != null) {
                    try {
                        var2_2.close();
                    }
                    catch (IOException var6_8) {
                        KDebug.printStackTrace(var6_8);
                    }
                }
                throw var4_10;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var2_2.close();
                }
                catch (IOException var6_6) {
                    KDebug.printStackTrace(var6_6);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block13;
                catch (IOException var3_9) {
                    KDebug.printStackTrace(var3_9);
                    PolicyTool.errorDialog(var0);
                    var5_4 = null;
                    if (var2_2 != null) {
                        try {
                            var2_2.close();
                        }
                        catch (IOException var6_7) {
                            KDebug.printStackTrace(var6_7);
                        }
                    }
                }
            }
        }
        if (PolicyTool.db.on()) {
            PolicyTool.db.println("save complete");
        }
    }

    private static void errorDialog(String string) {
        String string2 = KErrorMsg.getString(KEMC.EID_CANT_WRITE_TO_FILE_PARAM_1, string);
        JOptionPane.showMessageDialog(null, string2, "Error", 0);
    }

    private static boolean isOKToChangePolicy() {
        String string = "CTC has detected a modified policy file.\n\nPrevious versions of CTC required this\npolicy file modification to launch\nproperly.\n\nCisco has determined that removing the\nmodified policy in this file will\nimprove system security.\n\nIf older versions of CTC are no longer\nin use on this computer, it is safe\nto remove the modified policy.\n\nRemove the modified policy?";
        JCheckBox jCheckBox = new JCheckBox("Don't show this message again.", false);
        boolean bl = false;
        if (showPolicyDialog) {
            int n = JOptionPane.showConfirmDialog(null, new Object[]{string, jCheckBox}, "Change Policy File", 0);
            bl = n == 0;
            if (jCheckBox.isSelected()) {
                PolicyTool.setPrefAndSave();
            } else {
                PolicyTool.deletePrefAndSave();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setPrefAndSave() {
        Preferences preferences = prefs;
        synchronized (preferences) {
            prefs.setBoolean("ctc.ignore.dialogs.value", SHOW_POLICY_DIALOG, false);
            prefs.setProperty("ctc.ignore.dialogs.description", SHOW_POLICY_DIALOG, SHOW_POLICY_DIALOG_DESC);
            try {
                prefs.store();
            }
            catch (FileNotFoundException fileNotFoundException) {
                db.println("Cannot save prefs, FileNotFoundException");
            }
            catch (InterruptedIOException interruptedIOException) {
                db.println("Cannot save prefs, InterruptedIOException");
            }
            catch (IOException iOException) {
                db.println("Cannot save prefs, IOException");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deletePrefAndSave() {
        Preferences preferences = prefs;
        synchronized (preferences) {
            prefs.removeProperty("ctc.ignore.dialogs.value", SHOW_POLICY_DIALOG);
            prefs.removeProperty("ctc.ignore.dialogs.description", SHOW_POLICY_DIALOG);
            try {
                prefs.store();
            }
            catch (FileNotFoundException fileNotFoundException) {
                db.println("Cannot save prefs, FileNotFoundException");
            }
            catch (InterruptedIOException interruptedIOException) {
                db.println("Cannot save prefs, InterruptedIOException");
            }
            catch (IOException iOException) {
                db.println("Cannot save prefs, IOException");
            }
        }
    }
}

