/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.orb;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.avalon.framework.logger.Jdk14Logger;
import org.jacorb.util.Environment;
import org.jacorb.util.LoggerFactory;

public class JdkLoggerFactory
implements LoggerFactory {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
    private static boolean doLogTime = JdkLoggerFactory.getSysProp("ctc.logFile.time", false);
    private static boolean doLogThread = JdkLoggerFactory.getSysProp("ctc.logFile.thread", false);
    private static final String name = "jdk";
    private int defaultPriority = 0;
    private final Map namedLoggers = new HashMap();
    private boolean append = false;
    private Handler consoleHandler;
    private Handler defaultHandler = null;
    private Formatter logFormatter = new JacORBLogFormatter();

    private static boolean getSysProp(String string, boolean bl) {
        String string2;
        boolean bl2 = bl;
        String string3 = string2 = string == null ? null : System.getProperty(string);
        if (string2 != null) {
            string2.toLowerCase();
            if (string2.equals("true") || string2.equals("1")) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public static void setDoLogTime(boolean bl) {
        doLogTime = bl;
    }

    public static void setDoLogThread(boolean bl) {
        doLogThread = bl;
    }

    public JdkLoggerFactory() {
        String string = Environment.getProperty((String)"jacorb.log.default.verbosity");
        this.append = Environment.isPropertyOn((String)"jacorb.logfile.append");
        if (string != null) {
            if (string.toUpperCase().equals("DEBUG")) {
                string = "4";
            } else if (string.toUpperCase().equals("INFO")) {
                string = "3";
            } else if (string.toUpperCase().equals("WARN")) {
                string = "2";
            } else if (string.toUpperCase().equals("ERROR")) {
                string = "1";
            }
            try {
                this.defaultPriority = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.defaultPriority = -1;
            }
            switch (this.defaultPriority) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("'" + string + "' is an illegal" + " value for the property jacorb.log.default.verbosity. Valid values are between 0 and 4.");
                }
            }
        }
        this.consoleHandler = new ConsoleHandler();
        this.consoleHandler.setLevel(Level.FINEST);
        this.consoleHandler.setFormatter(this.logFormatter);
    }

    public void setDefaultPriority(int n) {
        this.defaultPriority = n;
    }

    public final String getLoggingBackendName() {
        return name;
    }

    public org.apache.avalon.framework.logger.Logger getNamedLogger(String string) {
        return this.getNamedLogger(string, null);
    }

    public org.apache.avalon.framework.logger.Logger getNamedRootLogger(String string) {
        return this.getNamedLogger(string, this.consoleHandler);
    }

    public org.apache.avalon.framework.logger.Logger getNamedLogger(String string, String string2, long l) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("The log file name cannot be null!");
        }
        FileHandler fileHandler = l == 0L ? new FileHandler(string2, this.append) : new FileHandler(string2, (int)l * 1000, 10000, this.append);
        fileHandler.setLevel(Level.FINEST);
        fileHandler.setFormatter(this.logFormatter);
        return this.getNamedLogger(string, fileHandler);
    }

    public org.apache.avalon.framework.logger.Logger getNamedLogger(String string, Handler handler) {
        Object v = this.namedLoggers.get(string);
        if (v != null) {
            return (org.apache.avalon.framework.logger.Logger)v;
        }
        Logger logger = Logger.getLogger(string);
        int n = this.getPriorityForNamedLogger(string);
        logger.setLevel(JdkLoggerFactory.intToLevel(n));
        logger.setUseParentHandlers(false);
        if (handler != null) {
            logger.addHandler(handler);
        } else if (this.defaultHandler == null) {
            logger.addHandler(this.consoleHandler);
        } else {
            logger.addHandler(this.defaultHandler);
        }
        Jdk14Logger jdk14Logger = new Jdk14Logger(logger);
        this.namedLoggers.put(string, jdk14Logger);
        return jdk14Logger;
    }

    public int getPriorityForNamedLogger(String string) {
        String string2 = string;
        while (!string2.equals("")) {
            String string3 = Environment.getProperty((String)(string2 + ".log.verbosity"));
            if (string3 != null) {
                if ((string3 = string3.trim()) != null && string3.toUpperCase().equals("DEBUG")) {
                    string3 = "4";
                } else if (string3 != null && string3.toUpperCase().equals("INFO")) {
                    string3 = "3";
                } else if (string3 != null && string3.toUpperCase().equals("WARN")) {
                    string3 = "2";
                } else if (string3 != null && string3.toUpperCase().equals("ERROR")) {
                    string3 = "1";
                }
                return Integer.parseInt(string3);
            }
            if (string2.lastIndexOf(".") >= 0) {
                string2 = string2.substring(0, string2.lastIndexOf("."));
                continue;
            }
            string2 = "";
        }
        return this.defaultPriority;
    }

    public static Level intToLevel(int n) {
        Level level = null;
        switch (n) {
            case 4: {
                level = Level.FINEST;
                break;
            }
            case 3: {
                level = Level.INFO;
                break;
            }
            case 2: {
                level = Level.WARNING;
                break;
            }
            default: {
                level = Level.SEVERE;
            }
        }
        return level;
    }

    public void setDefaultLogFile(String string, long l) throws IOException {
        FileHandler fileHandler = l == 0L ? new FileHandler(string, this.append) : new FileHandler(string, (int)l * 1000, 10000, this.append);
        fileHandler.setLevel(Level.FINEST);
        fileHandler.setFormatter(this.logFormatter);
    }

    public class JacORBLogFormatter
    extends Formatter {
        public String format(LogRecord logRecord) {
            StringBuffer stringBuffer = new StringBuffer();
            if (doLogTime) {
                long l = System.currentTimeMillis();
                String string = sdf.format(new Date(l));
                stringBuffer.append(string);
            }
            stringBuffer.append("[");
            stringBuffer.append(logRecord.getLoggerName());
            if (doLogThread) {
                stringBuffer.append("|");
                stringBuffer.append(Thread.currentThread().getName());
            }
            stringBuffer.append("] ");
            stringBuffer.append(logRecord.getLevel().toString());
            stringBuffer.append(": ");
            stringBuffer.append(logRecord.getMessage());
            stringBuffer.append("\n");
            Throwable throwable = logRecord.getThrown();
            if (throwable != null) {
                StringWriter stringWriter = new StringWriter();
                throwable.printStackTrace(new PrintWriter(stringWriter));
                stringBuffer.append(stringWriter.toString());
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }
    }
}

