/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core;

import cerent.util.KDebug;
import cerent.util.Preferences;
import com.cisco.ctc.core.CoreException;
import com.cisco.ctc.core.CoreVersionUtil;
import com.cisco.ctc.core.DownloadArea;
import com.cisco.ctc.core.ICoreVersionUtil;
import com.cisco.ctc.core.IFutureProofer;
import com.cisco.ctc.core.INgrp;
import com.cisco.ctc.core.VersionOrdinalComparator;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadAreas {
    private static final ICoreVersionUtil cvu = CoreVersionUtil.instance();
    private static final Debug db = new Debug("DownloadAreas");
    private static final Preferences prefs = Preferences.instance();
    private Map<String, DownloadArea> das = new HashMap<String, DownloadArea>();
    private Set<String> nodas;
    private HashMap<Comparable, DownloadArea> coreMapping = new HashMap();
    private static final Preferences ctcApplPrefs = DownloadAreas.getCtcApplPrefs();
    private static DownloadAreas instance = new DownloadAreas();
    private static Map<Comparable, DownloadArea> initialConfiguredDas = instance.getConfiguredDownloadAreas(ctcApplPrefs);

    private static Preferences getCtcApplPrefs() {
        Preferences preferences = !Preferences.defaultIsLauncher() ? prefs : Preferences.instance(Preferences.getDefaultCtcPrefsFileName());
        return preferences;
    }

    public static DownloadAreas instance() {
        return instance;
    }

    private DownloadAreas() {
    }

    public Map<Comparable, DownloadArea> getInitialConfiguredDas() {
        return initialConfiguredDas;
    }

    public DownloadArea getCoreMapping(Comparable comparable) {
        return this.coreMapping.get(comparable);
    }

    public boolean addCoreMapping(Comparable comparable, DownloadArea downloadArea) {
        DownloadArea downloadArea2 = this.coreMapping.put(comparable, downloadArea);
        return downloadArea2 == null;
    }

    public DownloadArea removeCoreMapping(Comparable comparable) {
        DownloadArea downloadArea = this.coreMapping.remove(comparable);
        return downloadArea;
    }

    public DownloadArea locateDownloadArea(String string) {
        if (string == null) {
            return null;
        }
        if (this.nodas.contains(string)) {
            if (db.isFinerEnabled()) {
                db.println("NE s/w version: " + string + " has no viable download area");
            }
            return null;
        }
        DownloadArea downloadArea = this.das.get(string);
        if (downloadArea == null) {
            Exception exception = null;
            try {
                downloadArea = new DownloadArea(string);
            }
            catch (IOException iOException) {
                exception = iOException;
            }
            catch (CoreException coreException) {
                exception = coreException;
            }
            if (exception != null) {
                if (db.isFinerEnabled()) {
                    db.println("NE s/w version: " + string + " failed download area discovery");
                    Debug.printStackTrace(exception);
                }
                this.nodas.add(string);
            } else {
                if (db.on()) {
                    db.println("NE s/w version: " + string + " has new discovered download area: " + downloadArea);
                }
                this.das.put(string, downloadArea);
            }
        }
        return downloadArea;
    }

    public void unlocateDownloadArea(String string) {
        this.das.remove(string);
        this.nodas.remove(string);
    }

    public void clear() {
        this.das.clear();
        this.nodas.clear();
    }

    public void cleanupDownloadArea(String string) {
        DownloadArea downloadArea = this.locateDownloadArea(string);
        if (downloadArea == null) {
            db.println("warning: no DA found for version: " + string);
        }
        this.cleanupDownloadArea(downloadArea);
    }

    public void cleanupDownloadArea(DownloadArea downloadArea) {
        if (downloadArea != null) {
            Exception exception = null;
            try {
                downloadArea.cleanArea();
                downloadArea.removeDirPreference();
            }
            catch (IOException iOException) {
                exception = iOException;
            }
            catch (CoreException coreException) {
                exception = coreException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                exception = classNotFoundException;
            }
            catch (InstantiationException instantiationException) {
                exception = instantiationException;
            }
            catch (InvocationTargetException invocationTargetException) {
                exception = invocationTargetException;
            }
            if (exception != null && db.on()) {
                Debug.printStackTrace(exception);
            }
        }
    }

    public void cleanupAllDownloadAreas() {
        Collection<DownloadArea> collection = initialConfiguredDas.values();
        for (DownloadArea downloadArea : collection) {
            this.cleanupDownloadArea(downloadArea);
        }
    }

    public void initFutureProofers() {
        if (initialConfiguredDas == null) {
            return;
        }
        Collection<DownloadArea> collection = initialConfiguredDas.values();
        for (DownloadArea downloadArea : collection) {
            try {
                downloadArea.initFutureProofer();
            }
            catch (IOException iOException) {
                Debug.printStackTrace(iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.printStackTrace(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                Debug.printStackTrace(instantiationException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Debug.printStackTrace(invocationTargetException);
            }
            catch (CoreException coreException) {
                Debug.printStackTrace(coreException);
            }
        }
    }

    public void disposeFutureProofers() {
        if (initialConfiguredDas == null) {
            return;
        }
        Collection<DownloadArea> collection = initialConfiguredDas.values();
        for (DownloadArea downloadArea : collection) {
            downloadArea.disposeFutureProofer();
        }
    }

    public synchronized Map<Comparable, DownloadArea> refreshConfiguredDownloadAreas(boolean bl) {
        boolean bl2 = ctcApplPrefs.checkForFileChange();
        if (bl || bl2) {
            initialConfiguredDas = this.getConfiguredDownloadAreas(ctcApplPrefs);
        } else {
            this.initFutureProofers();
        }
        return initialConfiguredDas;
    }

    public Map<Comparable, DownloadArea> refreshConfiguredDownloadAreas() {
        return this.refreshConfiguredDownloadAreas(true);
    }

    public synchronized void clearConfiguredDownloadAreas() {
        initialConfiguredDas = null;
    }

    public Map<Comparable, DownloadArea> getConfiguredDownloadAreas() {
        return this.getConfiguredDownloadAreas(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Map<Comparable, DownloadArea> getConfiguredDownloadAreas(Preferences preferences) {
        SortedMap<Comparable, DownloadArea> sortedMap = null;
        String[] stringArray = DownloadArea.getPrefItems(preferences);
        if (stringArray == null) {
            return sortedMap;
        }
        sortedMap = Collections.synchronizedSortedMap(new TreeMap(new VersionOrdinalComparator()));
        for (String string : stringArray) {
            IOException iOException2222;
            Object var20_24;
            String string2 = DownloadArea.getPrefNameFromPrefItem(string);
            String string3 = DownloadArea.getDownloadListUriFromPrefItem(string);
            String string4 = DownloadArea.getLauncherUriFromPrefItem(string);
            ZipFile zipFile = null;
            DownloadArea downloadArea = null;
            try {
                downloadArea = new DownloadArea(preferences, string2, string3, string4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                db.println("Cleaning up likely incomplete DA based on triplet: " + string2 + " " + string3 + " " + string4);
                Debug.printStackTrace(classNotFoundException);
                DownloadArea.removeDirPreferences(preferences, string2, string3, string4);
                var20_24 = null;
                if (zipFile == null) continue;
                try {
                    zipFile.close();
                }
                catch (IOException iOException2222) {}
                continue;
            }
            IFutureProofer iFutureProofer = downloadArea.getFutureProofer();
            String string5 = downloadArea.getLauncherPath();
            File file = new File(string5);
            zipFile = new JarFile(file);
            Manifest manifest = ((JarFile)zipFile).getManifest();
            INgrp iNgrp = iFutureProofer.getNgrp(manifest, string5);
            Comparable comparable = iNgrp.getManifestVersionOrdinal();
            if (db.on()) {
                db.println("found for coreVo: " + comparable + " DA: " + downloadArea);
            }
            sortedMap.put(comparable, downloadArea);
            var20_24 = null;
            if (zipFile == null) continue;
            try {
                zipFile.close();
            }
            catch (IOException iOException2222) {}
            continue;
            {
                catch (IOException iOException3) {
                    Debug.printStackTrace(iOException3);
                    var20_24 = null;
                    if (zipFile == null) continue;
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException2222) {}
                    continue;
                }
                catch (InstantiationException instantiationException) {
                    Debug.printStackTrace(instantiationException);
                    var20_24 = null;
                    if (zipFile == null) continue;
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException2222) {}
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    Debug.printStackTrace(invocationTargetException);
                    var20_24 = null;
                    if (zipFile == null) continue;
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException2222) {}
                    continue;
                }
                catch (CoreException coreException) {
                    Debug.printStackTrace(coreException);
                    var20_24 = null;
                    if (zipFile == null) continue;
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException2222) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var20_24 = null;
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException2222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return sortedMap;
    }

    public static void main(String[] stringArray) {
        instance.cleanupAllDownloadAreas();
    }

    public static class Debug
    extends KDebug {
        public Debug(String string) {
            super(string);
        }

        public final void dumpDiag() {
            instance;
            Map map = initialConfiguredDas;
            int n = map == null ? 0 : map.size();
            this.println("# download areas: " + n);
            if (n == 0) {
                return;
            }
            Iterator iterator = map.keySet().iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Comparable comparable = (Comparable)iterator.next();
                db.println(Integer.toString(n2) + "  VO: " + comparable + " - " + map.get(comparable));
                ++n2;
            }
        }
    }
}

