/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core;

import cerent.launcher.CachedJar;
import cerent.launcher.CmsClassLoader;
import cerent.util.KDebug;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.Preferences;
import com.cisco.ctc.core.AbstractClassLoaderLocatingStrategy;
import com.cisco.ctc.core.CacheLocator;
import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.ClassLoaderException;
import com.cisco.ctc.core.ClassLoaderKey;
import com.cisco.ctc.core.INgrp;
import com.cisco.ctc.core.NETypeEnum;
import com.cisco.ctc.core.NgrpAndURL;
import com.cisco.ctc.core.RetryableException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;

public class EleClassLoaderLocatingStrategy
extends AbstractClassLoaderLocatingStrategy {
    protected static final KDebug staticDb = new KDebug("CLLEleStrategy");
    private static EleClassLoaderLocatingStrategy instance = new EleClassLoaderLocatingStrategy(staticDb);
    private static final Preferences prefs = Preferences.instance();
    private static boolean eleCanBeGreaterThanNe = prefs.getBoolean("ctc", "elegreaterthanneversionok", true);
    private static boolean enableEleNeVersionWarning = prefs.getBoolean("ctc", "enableeleneversionwarning", true);
    private static boolean coreCanBeLowerThanEle = prefs.getBoolean("ctc", "coreCanBeLowerThanEle", false);
    private AbstractClassLoaderLocatingStrategy coreCllStrategy;

    public void setCoreCllStrategy(AbstractClassLoaderLocatingStrategy abstractClassLoaderLocatingStrategy) {
        this.coreCllStrategy = abstractClassLoaderLocatingStrategy;
    }

    protected EleClassLoaderLocatingStrategy(KDebug kDebug) {
        super(kDebug == null ? staticDb : kDebug);
    }

    public static EleClassLoaderLocatingStrategy instance() {
        return instance;
    }

    protected void checkCreatedClassLoader(CacheLocator.RequestState requestState, ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassLoaderException, IOException {
        super.checkCreatedClassLoader(requestState, classLoader);
        ClassLoader classLoader2 = classLoader.getParent();
        if (requestState.isDownloadingPermitted && this.isCoreClassLoader(classLoader2) && classLoader instanceof CmsClassLoader) {
            CmsClassLoader cmsClassLoader = (CmsClassLoader)classLoader;
            String string = cmsClassLoader.getSwVersion();
            String string2 = requestState.neFullSwVersion;
            Comparable comparable = this.getManifestComparable(cmsClassLoader);
            if (comparable.compareTo(requestState.neSwVersion) == 0 && string2 == null || !string2.equals(string)) {
                String string3 = "warning: NE " + requestState.getActualHostName() + "(API/SW vo:" + cvu.prettyDottedString(requestState.neSwVersion) + ") full version: " + string2 + " mismatches child CL (" + classLoader + "/vo:" + cvu.prettyDottedString(comparable) + ") full version: " + string;
                this.db.severe(string3);
                if (enableEleNeVersionWarning) {
                    KErrorMsg.displayWarning(null, KEMC.WID_ELE_CLASSLOADER_VERSION_MISMATCH, new Object[]{string, string2});
                }
                cmsClassLoader.setWarning(new ClassLoaderException(string3));
            }
        }
    }

    protected void checkParentClassLoaderAgainstNe(ClassLoaderEnum classLoaderEnum, Comparable comparable) throws ClassLoaderException {
        this.checkParentClassLoaderAgainstNe(classLoaderEnum, comparable, true);
    }

    protected ClassLoader findClassLoader(ClassLoaderEnum classLoaderEnum, Comparable comparable) {
        ClassLoader classLoader = !classLoaderEnum.isCore ? super.findClassLoader(classLoaderEnum, comparable) : (this.coreCllStrategy != null ? this.coreCllStrategy.findClassLoader(classLoaderEnum, comparable) : null);
        return classLoader;
    }

    private URL[] filterOutNewEles(Comparable comparable, URL[] uRLArray) {
        Comparable comparable2;
        String string;
        if (uRLArray == null) {
            return null;
        }
        int n = 0;
        for (URL uRL : uRLArray) {
            INgrp iNgrp = cvu.getNgrp(uRL);
            string = iNgrp.getFullVersionFormat();
            comparable2 = cvu.createManifestFullVersionOrdinal(string);
            if (comparable.compareTo(comparable2) < 0) continue;
            ++n;
        }
        URL[] uRLArray2 = new URL[n];
        int n2 = 0;
        for (URL uRL : uRLArray) {
            INgrp iNgrp = cvu.getNgrp(uRL);
            string = iNgrp.getFullVersionFormat();
            comparable2 = cvu.createManifestFullVersionOrdinal(string);
            if (comparable.compareTo(comparable2) < 0) continue;
            uRLArray2[n2++] = uRL;
        }
        return uRLArray2;
    }

    private ClassLoader[] filterOutNewEles(Comparable comparable, ClassLoader[] classLoaderArray) {
        if (classLoaderArray == null) {
            return null;
        }
        int n = 0;
        for (ClassLoader classLoader : classLoaderArray) {
            String string;
            if (!(classLoader instanceof CmsClassLoader) || comparable.compareTo(string = ((CmsClassLoader)classLoader).getSwVersion()) < 0) continue;
            ++n;
        }
        ClassLoader[] classLoaderArray2 = new ClassLoader[n];
        int n2 = 0;
        for (ClassLoader classLoader : classLoaderArray) {
            String string;
            if (!(classLoader instanceof CmsClassLoader) || comparable.compareTo(string = ((CmsClassLoader)classLoader).getSwVersion()) < 0) continue;
            classLoaderArray2[n2++] = classLoader;
        }
        return classLoaderArray2;
    }

    protected ClassLoader lookupClassLoader(CacheLocator.RequestState requestState) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ClassLoader classLoader;
        ClassLoader[] classLoaderArray;
        int n;
        ClassLoader[] classLoaderArray2 = this.getClassLoaders(requestState.clEnum);
        if (this.db.isFinestEnabled()) {
            int n2 = classLoaderArray2 == null || classLoaderArray2.length == 0 ? 0 : classLoaderArray2.length;
            this.db.finest("determining best ELE CL among: " + n2 + " candidates for: " + requestState);
        }
        if (!eleCanBeGreaterThanNe) {
            classLoaderArray2 = this.filterOutNewEles(requestState.neActualSwVersion, classLoaderArray2);
        }
        int n3 = n = (classLoaderArray = cvu.getBestELEClassLoader(requestState.neSwVersion, requestState.netype, requestState.hostName, classLoaderArray2)) == null || classLoaderArray.length == 0 ? 0 : classLoaderArray.length;
        if (this.db.isFinestEnabled()) {
            int n4 = classLoaderArray2 == null || classLoaderArray2.length == 0 ? 0 : classLoaderArray2.length;
            this.db.finest("number of compatible ELE Cl candidates found: " + n);
        }
        ClassLoader classLoader2 = classLoader = n == 0 ? null : classLoaderArray[0];
        if (n > 0 && classLoader != null) {
            if (classLoader instanceof CmsClassLoader) {
                Comparable comparable = ((CmsClassLoader)classLoader).getClassLoaderKey().getNeSwVersion();
                if (requestState.isDownloadingPermitted && requestState.neActualSwVersion != null && requestState.neActualSwVersion.compareTo(comparable) > 0) {
                    if (this.db.on()) {
                        this.db.println("best ELE chosen will not be: " + classLoader + " for: " + requestState + " relying on 'best ELE jar' phase to download a newer ELE for consideration");
                    }
                    requestState.bestEleCl = classLoader;
                    classLoader = null;
                }
            }
            if (classLoader != null && this.db.on()) {
                this.db.println("best ELE chosen was: " + classLoader + " for: " + requestState);
            }
        }
        return classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ClassLoader locateClassLoader(String string, NETypeEnum nETypeEnum, ClassLoaderEnum classLoaderEnum, Comparable comparable, Comparable comparable2) throws ClassNotFoundException, MalformedURLException, IOException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassLoaderException, RetryableException {
        CacheLocator.RequestState requestState;
        if (classLoaderEnum.isCore) {
            throw new IllegalArgumentException("cannot use this locator: " + this.getClass().getName() + " for a CORE CL: " + (Object)((Object)classLoaderEnum));
        }
        if (comparable2 != null && comparable2.compareTo(comparable) < 0) {
            throw new ClassNotFoundException("core " + comparable2 + " cannot support newer ELE version: " + comparable);
        }
        if (comparable == null || cvu.isUnavailable(comparable)) {
            throw new ClassLoaderException("Cannot determine ELE classloader for an NE: '" + string + "' whose sw/api version number is unusable");
        }
        NETypeEnum nETypeEnum2 = cvu.isUnifiedEle(comparable) ? NETypeEnum.NE_DONT_CARE : nETypeEnum;
        ClassLoader classLoader = super.locateClassLoader(string, nETypeEnum2, classLoaderEnum, comparable, null, requestState = this.createRequestState(string, nETypeEnum2, classLoaderEnum, comparable));
        if (classLoader != null) {
            return classLoader;
        }
        ClassLoader classLoader2 = this.lookupParent(classLoaderEnum, comparable);
        ClassLoaderKey classLoaderKey = new ClassLoaderKey(classLoaderEnum, comparable, nETypeEnum2);
        ClassLoaderKey classLoaderKey2 = null;
        try {
            NgrpAndURL[] ngrpAndURLArray;
            classLoaderKey2 = this.acquireLock(classLoaderKey);
            if (classLoaderKey2 == null) {
                RetryableException retryableException = new RetryableException(classLoaderKey.toString());
                if (!this.db.isFinerEnabled()) throw retryableException;
                this.db.finer("Retrying to acquire a classloader based on: " + classLoaderKey);
                throw retryableException;
            }
            URL[] uRLArray = this.locateEleBootstrapJarURLsInCache(requestState);
            int n = uRLArray == null ? 0 : uRLArray.length;
            URL uRL = null;
            if (this.db.on()) {
                this.db.println("determining MOST compatible jar for NE API/SW version " + cvu.prettyDottedString(comparable) + " among: " + n + " choices: " + EleClassLoaderLocatingStrategy.toString(uRLArray));
            }
            if (!eleCanBeGreaterThanNe) {
                uRLArray = this.filterOutNewEles(requestState.neActualSwVersion, uRLArray);
            }
            boolean bl = (ngrpAndURLArray = cvu.getBestELEJars(classLoader2, comparable, requestState.neActualSwVersion, requestState.netype, string, uRLArray)) != null && ngrpAndURLArray.length > 0;
            boolean bl2 = false;
            if (!bl) {
                if (this.db.isFinestEnabled()) {
                    this.db.finest("downloading new ELE: " + requestState);
                }
                uRL = this.addBootstrapJarToCache(requestState);
            } else if (requestState.isDownloadingPermitted && requestState.neActualSwVersion.compareTo(ngrpAndURLArray[0].ngrp.getManifestVersionOrdinal()) > 0 && (coreCanBeLowerThanEle || comparable2 != null && comparable2.compareTo(requestState.neActualSwVersion) >= 0)) {
                if (this.db.on()) {
                    this.db.println("best ELE found sofar is based on: " + ngrpAndURLArray[0] + " - downloading better ELE: " + requestState);
                }
                uRL = this.addBootstrapJarToCache(requestState);
                bl2 = true;
            } else {
                requestState.jarVo = ngrpAndURLArray[0].ngrp.getManifestVersionOrdinal();
            }
            if (!bl && uRL == null) {
                throw new ClassLoaderException("no ELE jars could be found for NE API/SW version: " + cvu.prettyDottedString(comparable));
            }
            if (uRL == null) {
                uRL = ngrpAndURLArray[0].url;
            }
            if (this.db.on()) {
                this.db.println("MOST compatible jar for NE API/SW version " + cvu.prettyDottedString(comparable) + " is: " + uRL);
            }
            uRLArray = new URL[]{uRL};
            Comparable comparable3 = requestState.jarVo != null ? requestState.jarVo : requestState.neActualSwVersion;
            ClassLoader classLoader3 = null;
            if (!bl2 && requestState.bestEleCl != null) {
                if (coreCanBeLowerThanEle && comparable2 != null && comparable2.compareTo(requestState.neActualSwVersion) < 0) {
                    if (!this.db.isFinestEnabled()) throw new ClassNotFoundException("core " + comparable2 + " cannot support newer ELE version: " + requestState.neActualSwVersion);
                    this.db.finest("core " + comparable2 + " cannot support newer ELE version: " + requestState.neActualSwVersion);
                    this.db.finest("a compatible/existing ELE CL was NOT found and  downloading a more compatible ELE jar is prevented ctc.coreCanBeLowerThanEle = " + coreCanBeLowerThanEle);
                    throw new ClassNotFoundException("core " + comparable2 + " cannot support newer ELE version: " + requestState.neActualSwVersion);
                }
                classLoader3 = requestState.bestEleCl;
                if (this.db.isFinestEnabled()) {
                    this.db.finest("NE " + requestState.getActualHostName() + " will be managed by existing ELE classloader: " + classLoader3);
                }
            } else {
                classLoader3 = new CmsClassLoader(classLoaderEnum, comparable3, nETypeEnum2, uRLArray, classLoader2);
                if (this.db.isFinestEnabled()) {
                    this.db.finest("NE " + requestState.getActualHostName() + " will be managed by new ELE classloader: " + classLoader3);
                }
            }
            if (classLoader3 instanceof CmsClassLoader) {
                CachedJar cachedJar = ((CmsClassLoader)classLoader3).getCachedJar();
                cachedJar.setNeType(requestState.netype);
                if (this.db.on()) {
                    this.db.println("CJ.sourceName() returned: " + cachedJar.sourceName());
                }
            }
            classLoader = this.addClassLoader(requestState, classLoader3);
            Object var22_22 = null;
            if (classLoaderKey2 == null) return classLoader;
        }
        catch (Throwable throwable) {
            Object var22_23 = null;
            if (classLoaderKey2 == null) throw throwable;
            this.releaseLock(classLoaderKey2);
            throw throwable;
        }
        this.releaseLock(classLoaderKey2);
        return classLoader;
    }
}

