/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core;

import com.cisco.ctc.core.IJreReqs;
import com.cisco.ctc.core.IJreVersion;
import com.cisco.ctc.core.JreVersion;

public final class JreReqs
implements IJreReqs {
    public static final JreReqs JRE_5_ONLY;
    public static final JreReqs CURRENT;
    public final JreVersion MINIMUM_VERSION;
    public final JreVersion MAXIMUM_VERSION;
    public final JreVersion RECOMMENDED_VERSION;

    public JreReqs(JreVersion jreVersion, JreVersion jreVersion2, JreVersion jreVersion3) {
        this.MINIMUM_VERSION = jreVersion;
        this.MAXIMUM_VERSION = jreVersion2;
        this.RECOMMENDED_VERSION = jreVersion3;
    }

    public JreReqs(IJreReqs iJreReqs) {
        this(new JreVersion(iJreReqs.getMinimum()), new JreVersion(iJreReqs.getMaximum()), new JreVersion(iJreReqs.getRecommended()));
    }

    public IJreVersion getMinimum() {
        return this.MINIMUM_VERSION;
    }

    public IJreVersion getMaximum() {
        return this.MAXIMUM_VERSION;
    }

    public IJreVersion getRecommended() {
        return this.RECOMMENDED_VERSION;
    }

    public boolean meetsReqs(IJreVersion iJreVersion) {
        return this.MINIMUM_VERSION.compareTo(iJreVersion) <= 0;
    }

    public boolean isUntested(IJreVersion iJreVersion) {
        return this.MAXIMUM_VERSION.compareTo(iJreVersion) <= 0;
    }

    public boolean isTested(IJreVersion iJreVersion) {
        return this.meetsReqs(iJreVersion) && !this.isUntested(iJreVersion);
    }

    public String toString() {
        return "MIN=" + this.MINIMUM_VERSION + " REC=" + this.RECOMMENDED_VERSION + " MAX=" + this.MAXIMUM_VERSION;
    }

    static {
        CURRENT = JRE_5_ONLY = new JreReqs(JreVersion.JRE_5, JreVersion.JRE_6, JreVersion.JRE_5);
    }
}

