/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.cache;

import cerent.util.IDebugDiag;
import cerent.util.KDebug;
import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.ClientFutureProofer;
import com.cisco.ctc.core.CoreConstants;
import com.cisco.ctc.core.CoreException;
import com.cisco.ctc.core.CoreVersionUtil;
import com.cisco.ctc.core.CtcBootstrapJar;
import com.cisco.ctc.core.FileNotWriteableException;
import com.cisco.ctc.core.ICoreVersionUtil;
import com.cisco.ctc.core.INgrp;
import com.cisco.ctc.core.NETypeEnum;
import com.cisco.ctc.core.NameVersion;
import com.cisco.ctc.core.cache.CtcCachedFile;
import com.cisco.ctc.core.cache.ICacheManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Observable;
import java.util.jar.JarFile;

public class CacheManager
extends Observable
implements ICacheManager {
    private static final CacheManager instance = new CacheManager();
    private static final JarFileFilter JAR_FILTER = new JarFileFilter();
    private static final String CLEAN_ME_FILE = "cache.cleanme";
    private static final ICoreVersionUtil cvu = CoreVersionUtil.instance();
    private static boolean refreshedOnce = false;
    private HashMap<String, INgrp> ngrpMap = new HashMap();
    private CmDebug db = new CmDebug();
    private String[] originalCacheDirList;
    private long[] originalLastModDates;
    private String writeDir;
    private LinkedList<CtcCachedFile> allCachedFiles = new LinkedList();
    private HashMap<CtcBootstrapJar, CtcCachedFile> bjarMap = new HashMap();
    private HashMap<String, CtcCachedFile> externalMap = new HashMap();
    private Object maplock = new Object();

    private CacheManager() {
    }

    public void refresh(String[] stringArray) throws IOException {
        this.refresh(stringArray, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String[] stringArray, int n) throws IOException {
        int n2;
        if (stringArray == null || stringArray.length == 0) {
            throw new IOException("The cache directory list is empty.");
        }
        if (n < 0 || n >= stringArray.length) {
            throw new IOException("Write directory index: " + n + " is out of bounds");
        }
        this.ngrpMap.clear();
        if (this.db.on()) {
            this.db.println("Directories passed are:");
            String[] objectArray = stringArray;
            n2 = objectArray.length;
            for (int string = 0; string < n2; ++string) {
                String bl = objectArray[string];
                this.db.println("   " + bl);
            }
        }
        long[] lArray = new long[stringArray.length];
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            String file = stringArray[n2];
            File file2 = new File(file);
            if (!file2.exists()) {
                throw new IOException("The cache directory " + file + " does not exist.");
            }
            lArray[n2] = file2.lastModified();
            if (file2.isFile()) {
                throw new IOException(file + " is not a directory.");
            }
            stringArray[n2] = file2.getCanonicalPath();
        }
        n2 = 0;
        File file = null;
        Object object = this.maplock;
        synchronized (object) {
            refreshedOnce = true;
            this.allCachedFiles.clear();
            this.externalMap.clear();
            this.bjarMap.clear();
            this.originalCacheDirList = stringArray;
            this.originalLastModDates = lArray;
            this.writeDir = this.originalCacheDirList[n];
            for (String string : stringArray) {
                File file3 = new File(string);
                String[] stringArray2 = file3.list(JAR_FILTER);
                if (this.db.on()) {
                    this.db.println("Jar files found in " + file3 + " (" + stringArray2.length + "):");
                    for (String string2 : stringArray2) {
                        this.db.println(string2);
                    }
                }
                for (String string2 : stringArray2) {
                    if (n2 == 0 && CoreConstants.isDownloadingPermitted && string2.equals(CLEAN_ME_FILE)) {
                        n2 = 1;
                        file = new File(file3, string2);
                    }
                    try {
                        CtcCachedFile ctcCachedFile = this.check(string, string2);
                        if (ctcCachedFile.state == CtcCachedFile.State.EXTERNAL) {
                            int n3 = string2.lastIndexOf(46);
                            String string3 = string2.substring(0, n3);
                            if (this.externalMap.containsKey(string3)) {
                                this.db.warning("warning: duplicate external jar for the " + this.externalMap.get((Object)string3).file + " (file eclipsed was: " + ctcCachedFile.file + ")");
                                ctcCachedFile.state = CtcCachedFile.State.ECLIPSED;
                            } else {
                                this.externalMap.put(string3, ctcCachedFile);
                            }
                        } else {
                            if (this.bjarMap.containsKey(ctcCachedFile.bootstrapJar)) {
                                this.db.warning("warning: duplicate bootstrap cache jar for the " + (Object)((Object)ctcCachedFile.bootstrapJar.getClEnum()) + " Classloader is: " + this.bjarMap.get((Object)ctcCachedFile.bootstrapJar).file + " (file eclipsed was: " + ctcCachedFile.file + ")");
                                ctcCachedFile.state = CtcCachedFile.State.ECLIPSED;
                            }
                            if (ctcCachedFile.state == CtcCachedFile.State.VALID) {
                                this.bjarMap.put(ctcCachedFile.bootstrapJar, ctcCachedFile);
                            } else {
                                this.db.severe(ctcCachedFile.state.toString() + ":" + ctcCachedFile.getPath());
                            }
                        }
                        this.allCachedFiles.addLast(ctcCachedFile);
                    }
                    catch (RuntimeException runtimeException) {
                        this.db.println("error encountered on cache dir jar: " + string2);
                        CmDebug.printStackTrace(runtimeException);
                        throw runtimeException;
                    }
                }
            }
        }
        this.setChanged();
        this.notifyObservers();
        if (this.db.isFinestEnabled()) {
            this.db.dumpDiag();
        }
        if (n2 != 0) {
            this.db.println("Startup cache cleanup running");
            boolean bl = this.deleteCache();
            if (!bl) {
                this.db.println("Startup cache cleanup was not successful");
                this.db.println("Check for a rogue CTC/java process holding onto 1/more of the cached jar files");
            }
            file.delete();
            try {
                CoreConstants.prefs.store();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void refresh() throws IOException {
        this.refresh(this.originalCacheDirList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesNeedRefresh() throws IOException {
        boolean bl = false;
        Object object = this.maplock;
        synchronized (object) {
            for (int i = 0; i < this.originalCacheDirList.length && !bl; ++i) {
                String string = this.originalCacheDirList[i];
                File file = new File(string);
                bl = this.originalLastModDates[i] != file.lastModified();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private CtcCachedFile check(String var1_1, String var2_2) {
        block44: {
            block43: {
                var3_3 = new File(var1_1, var2_2);
                if (this.db.on()) {
                    this.db.println("Checking " + var3_3);
                }
                if ((var4_4 = CacheManager.cvu.parseBootstrapJarName(var2_2)) == null) {
                    return new CtcCachedFile(var3_3);
                }
                var5_5 = null;
                var6_6 = var4_4.getClEnum();
                try {
                    var7_7 = var3_3.toURI().toURL();
                    var8_10 /* !! */  = var6_6.isCore != false ? var6_6 : ClassLoaderEnum.IF;
                    var5_5 = CacheManager.cvu.getNgrp((URL)var7_7, var8_10 /* !! */ );
                }
                catch (MalformedURLException var7_8) {
                    CmDebug.printStackTrace(var7_8);
                }
                catch (UnsupportedClassVersionError var7_9) {
                    if (!this.db.on()) break block43;
                    CmDebug.printStackTrace(var7_9);
                }
            }
            if (var5_5 == null && var6_6.equals((Object)ClassLoaderEnum.SYSTEM)) {
                var7_7 = null;
                try {
                    var8_10 /* !! */  = var3_3.getCanonicalPath();
                    var9_17 = new ClientFutureProofer((String)var8_10 /* !! */ );
                    var7_7 = new JarFile(var3_3);
                    var10_18 = var7_7.getManifest();
                    var5_5 = var9_17.getNgrp(var10_18, (String)var8_10 /* !! */ );
                    var12_19 = null;
                    ** if (var7_7 == null) goto lbl-1000
                }
                catch (Throwable var11_33) {
                    var12_25 = null;
                    if (var7_7 != null) {
                        try {
                            var7_7.close();
                        }
                        catch (IOException var13_32) {
                            // empty catch block
                        }
                    }
                    throw var11_33;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var7_7.close();
                    }
                    catch (IOException var13_26) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block44;
                    catch (ClassNotFoundException var8_11) {
                        if (this.db.on()) {
                            CmDebug.printStackTrace(var8_11);
                        }
                        var12_20 = null;
                        if (var7_7 != null) {
                            try {
                                var7_7.close();
                            }
                            catch (IOException var13_27) {}
                        }
                        break block44;
                    }
                    catch (InstantiationException var8_12) {
                        if (this.db.on()) {
                            CmDebug.printStackTrace(var8_12);
                        }
                        var12_21 = null;
                        if (var7_7 != null) {
                            try {
                                var7_7.close();
                            }
                            catch (IOException var13_28) {}
                        }
                        break block44;
                    }
                    catch (InvocationTargetException var8_13) {
                        if (this.db.on()) {
                            CmDebug.printStackTrace(var8_13);
                        }
                        var12_22 = null;
                        if (var7_7 != null) {
                            try {
                                var7_7.close();
                            }
                            catch (IOException var13_29) {}
                        }
                        break block44;
                    }
                    catch (IOException var8_14) {
                        if (this.db.on()) {
                            CmDebug.printStackTrace(var8_14);
                        }
                        var12_23 = null;
                        if (var7_7 != null) {
                            try {
                                var7_7.close();
                            }
                            catch (IOException var13_30) {}
                        }
                        break block44;
                    }
                    catch (CoreException var8_15) {
                        if (this.db.on()) {
                            CmDebug.printStackTrace(var8_15);
                        }
                        var12_24 = null;
                        if (var7_7 != null) {
                            try {
                                var7_7.close();
                            }
                            catch (IOException var13_31) {}
                        }
                    }
                }
            }
        }
        var7_7 = CtcCachedFile.State.INVALID;
        var8_16 = false;
        if (var5_5 == null || var5_5.isEmpty()) {
            this.db.println("NGRP missing in the manifest:" + var3_3);
        } else {
            var9_17 = var5_5.getManifestVersionOrdinal();
            if (var9_17 == null) {
                this.db.println("Comparable(VO) missing in the manifest:" + var3_3);
            } else if (var4_4.getVersion() == null) {
                var4_4.setVersion((Comparable)var9_17);
                var7_7 = CtcCachedFile.State.VALID;
            } else if (var9_17.compareTo(var4_4.getVersion()) == 0) {
                var7_7 = CtcCachedFile.State.VALID;
            }
            if (var6_6.isCore) {
                var8_16 = true;
            }
        }
        var9_17 = new CtcCachedFile(var3_3, (CtcCachedFile.State)var7_7, var4_4);
        if (var8_16) {
            this.ngrpMap.put(var9_17.getPath(), var5_5);
        }
        return var9_17;
    }

    public CtcCachedFile store(File file, NETypeEnum nETypeEnum, ClassLoaderEnum classLoaderEnum, Comparable comparable, boolean bl) throws IOException {
        return this.store(file, new CtcBootstrapJar(classLoaderEnum, nETypeEnum, comparable), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CtcCachedFile store(File file, CtcBootstrapJar ctcBootstrapJar, boolean bl) throws IOException {
        CtcCachedFile ctcCachedFile;
        Object object = this.maplock;
        synchronized (object) {
            ctcCachedFile = this.bjarMap.get(ctcBootstrapJar);
            if (ctcCachedFile == null) {
                File file2 = this.move(file, ctcBootstrapJar.toString(), bl);
                ctcCachedFile = new CtcCachedFile(file2, CtcCachedFile.State.VALID, ctcBootstrapJar);
                this.bjarMap.put(ctcBootstrapJar, ctcCachedFile);
                this.allCachedFiles.addFirst(ctcCachedFile);
                this.setChanged();
            } else {
                file.delete();
                if (this.db.on()) {
                    this.db.println("Store bootstrap jar already in cache. File deleted:" + file.toString());
                }
            }
        }
        if (this.db.on()) {
            this.db.println("Store bootstrap jar " + ctcBootstrapJar + " cached file=" + ctcCachedFile);
        }
        this.notifyObservers();
        return ctcCachedFile;
    }

    public CtcCachedFile store(File file, CtcBootstrapJar ctcBootstrapJar) throws IOException {
        return this.store(file, ctcBootstrapJar, true);
    }

    public CtcCachedFile store(File file, NameVersion nameVersion) throws IOException {
        return this.store(file, nameVersion.toString(), nameVersion.name);
    }

    public CtcCachedFile store(File file, String string) throws IOException {
        return this.store(file, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CtcCachedFile store(File file, String string, String string2) throws IOException {
        CtcCachedFile ctcCachedFile;
        Object object = this.maplock;
        synchronized (object) {
            if (string2 != null && !string2.equals(string) && (ctcCachedFile = this.externalMap.get(string2)) != null) {
                this._delete(ctcCachedFile);
                if (file == null) {
                    file = ctcCachedFile.file;
                }
            }
            if (file == null) {
                return null;
            }
            ctcCachedFile = this.externalMap.get(string);
            if (ctcCachedFile == null) {
                File file2 = this.move(file, string, true);
                ctcCachedFile = new CtcCachedFile(file2);
                this.externalMap.put(string, ctcCachedFile);
                this.allCachedFiles.addFirst(ctcCachedFile);
                this.setChanged();
            } else {
                if (!file.delete()) {
                    file.deleteOnExit();
                }
                if (this.db.on()) {
                    this.db.println("Store external jar name already in cache. File deleted:" + file.toString());
                }
            }
        }
        if (this.db.on()) {
            this.db.println("Store external jar name " + string + " cached file=" + ctcCachedFile);
        }
        this.notifyObservers();
        return ctcCachedFile;
    }

    private File move(File file, String string, boolean bl) throws IOException {
        boolean bl2;
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        File file2 = new File(this.writeDir, string + ".jar");
        if (file.equals(file2)) {
            return file2;
        }
        if (file2.exists()) {
            file2.delete();
        }
        boolean bl3 = bl2 = bl && file.renameTo(file2);
        if (!bl2) {
            this.copy(file, file2, bl);
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(File file, File file2, boolean bl) throws IOException {
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        block15: {
            fileInputStream = null;
            fileOutputStream = null;
            byte[] byArray = new byte[8192];
            int n = -1;
            try {
                fileOutputStream = new FileOutputStream(file2);
            }
            catch (IOException iOException) {
                throw new FileNotWriteableException(iOException, file2);
            }
            try {
                fileInputStream = new FileInputStream(file);
                while ((n = fileInputStream.read(byArray)) > -1) {
                    try {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    catch (IOException iOException) {
                        throw new FileNotWriteableException(iOException, file2);
                    }
                }
                Object var10_10 = null;
                if (fileInputStream == null) break block15;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (fileInputStream != null) {
                    fileInputStream.close();
                    if (bl) {
                        file.delete();
                    }
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                throw throwable;
            }
            fileInputStream.close();
            if (bl) {
                file.delete();
            }
        }
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
        if (this.db.on()) {
            if (fileInputStream != null && fileOutputStream != null) {
                this.db.println("Input file " + file + "Was copied from the input file system to" + "output files system as" + file2 + ".  Input file deleted");
            } else {
                this.db.println("Input file " + file + "could not be copied from the input file system to" + "output files system as" + file2 + ".  Input file not deleted");
            }
        }
    }

    public CtcCachedFile retrieve(NETypeEnum nETypeEnum, ClassLoaderEnum classLoaderEnum, Comparable comparable) {
        return this.retrieve(new CtcBootstrapJar(classLoaderEnum, nETypeEnum, comparable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CtcCachedFile retrieve(CtcBootstrapJar ctcBootstrapJar) {
        CtcCachedFile ctcCachedFile;
        Object object = this.maplock;
        synchronized (object) {
            ctcCachedFile = this.bjarMap.get(ctcBootstrapJar);
        }
        if (this.db.on()) {
            this.db.println("retrieve " + ctcBootstrapJar.toString() + "=" + ctcCachedFile);
        }
        return ctcCachedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CtcCachedFile retrieve(String string) {
        CtcCachedFile ctcCachedFile;
        Object object = this.maplock;
        synchronized (object) {
            ctcCachedFile = this.externalMap.get(string);
        }
        if (this.db.on()) {
            this.db.println("retrieve " + string + "=" + ctcCachedFile);
        }
        return ctcCachedFile;
    }

    public CtcCachedFile retrieve(NameVersion nameVersion, boolean bl) {
        CtcCachedFile ctcCachedFile = this.retrieve(nameVersion.toString());
        if (ctcCachedFile == null && !bl) {
            ctcCachedFile = this.retrieve(nameVersion.name);
        }
        return ctcCachedFile;
    }

    public CtcCachedFile retrieve(NameVersion nameVersion) {
        return this.retrieve(nameVersion, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CtcCachedFile[] retrieve(NETypeEnum nETypeEnum, ClassLoaderEnum classLoaderEnum) {
        LinkedList<CtcCachedFile> linkedList = new LinkedList<CtcCachedFile>();
        if (nETypeEnum == null) {
            nETypeEnum = NETypeEnum.NE_DONT_CARE;
        }
        Object object = this.maplock;
        synchronized (object) {
            for (CtcBootstrapJar ctcBootstrapJar : this.bjarMap.keySet()) {
                if (ctcBootstrapJar.getClEnum() != classLoaderEnum || ctcBootstrapJar.getNeType() != nETypeEnum) continue;
                linkedList.add(this.bjarMap.get(ctcBootstrapJar));
            }
        }
        return linkedList.toArray(new CtcCachedFile[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CtcCachedFile[] retrieveAll() {
        Object object = this.maplock;
        synchronized (object) {
            return this.allCachedFiles.toArray(new CtcCachedFile[0]);
        }
    }

    public String[] getCacheDirList() {
        return this.originalCacheDirList;
    }

    public boolean delete(CtcCachedFile ctcCachedFile) {
        return this.delete(ctcCachedFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean delete(CtcCachedFile ctcCachedFile, boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        Object object = this.maplock;
        synchronized (object) {
            bl3 = this._delete(ctcCachedFile);
        }
        System.gc();
        boolean bl4 = bl2 = !ctcCachedFile.file.exists() || ctcCachedFile.file.delete();
        if (this.db.on()) {
            this.db.println("Del " + ctcCachedFile.file + " res=" + bl2);
        }
        if (bl3) {
            this.setChanged();
            if (bl) {
                this.notifyObservers();
            }
        }
        return bl2;
    }

    private boolean _delete(CtcCachedFile ctcCachedFile) {
        boolean bl = false;
        if (ctcCachedFile.state == CtcCachedFile.State.VALID) {
            if (ctcCachedFile.bootstrapJar != null) {
                if (this.db.on()) {
                    this.db.println("Deleting bootstrap jar: " + ctcCachedFile.bootstrapJar);
                }
                this.bjarMap.remove(ctcCachedFile.bootstrapJar);
            }
        } else if (ctcCachedFile.state == CtcCachedFile.State.EXTERNAL) {
            String string = ctcCachedFile.file.getName();
            string = string.substring(0, string.lastIndexOf(46));
            if (this.db.on()) {
                this.db.println("Deleting external jar: " + string);
            }
            this.externalMap.remove(string);
        } else {
            this.db.println("Deleting invalid bootstrap jar: " + ctcCachedFile.bootstrapJar + " ST=" + (Object)((Object)ctcCachedFile.state));
        }
        bl = this.allCachedFiles.remove(ctcCachedFile);
        return bl;
    }

    public boolean deleteCache() {
        if (this.db.on()) {
            this.db.println("Deleting cache");
        }
        File file = new File(this.writeDir);
        LinkedList<CtcCachedFile> linkedList = new LinkedList<CtcCachedFile>();
        for (CtcCachedFile object2 : this.allCachedFiles) {
            if (!file.equals(object2.file.getParentFile())) break;
            linkedList.add(object2);
        }
        boolean bl = true;
        for (CtcCachedFile ctcCachedFile : linkedList) {
            if (this.db.on()) {
                this.db.println("Deleting " + ctcCachedFile.getPath());
            }
            bl &= this.delete(ctcCachedFile, false);
        }
        this.notifyObservers();
        if (!bl) {
            this.db.println("Cache cleanup was NOT successful");
        }
        File file2 = new File(this.writeDir, CLEAN_ME_FILE);
        boolean bl2 = file2.exists();
        if (CoreConstants.isDownloadingPermitted) {
            if (!bl) {
                if (!bl2) {
                    try {
                        file2.createNewFile();
                        this.db.println("Requested cache cleanup was not successful");
                        this.db.println("Will attempt remaining cache cleanup at next CTC launcher startup");
                    }
                    catch (IOException iOException) {
                        this.db.println("Requested cache cleanup on restart failed");
                    }
                }
            } else if (bl2) {
                file2.delete();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INgrp getNgrp(CtcCachedFile ctcCachedFile) {
        INgrp iNgrp = null;
        Object object = this.maplock;
        synchronized (object) {
            iNgrp = this.ngrpMap.get(ctcCachedFile.getPath());
        }
        return iNgrp;
    }

    public static CacheManager instance() {
        return instance;
    }

    public class CmDebug
    extends KDebug
    implements IDebugDiag {
        public CmDebug() {
            super("CacheManager");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void showAll() {
            this.println("--- Global List:");
            Object object = CacheManager.this.maplock;
            synchronized (object) {
                for (CtcCachedFile ctcCachedFile : CacheManager.this.allCachedFiles) {
                    this.println("   " + ctcCachedFile.toString());
                }
                this.println("--- Write directory:" + CacheManager.this.writeDir);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void showExternal() {
            this.println("--- External Map:");
            Object object = CacheManager.this.maplock;
            synchronized (object) {
                for (CtcCachedFile ctcCachedFile : CacheManager.this.externalMap.values()) {
                    this.println("   " + ctcCachedFile.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void showBjar() {
            this.println("--- Bootstrap Map:");
            Object object = CacheManager.this.maplock;
            synchronized (object) {
                for (CtcCachedFile ctcCachedFile : CacheManager.this.bjarMap.values()) {
                    this.println("   " + ctcCachedFile.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void showNgrp() {
            this.println("--- NGRP Map:");
            Object object = CacheManager.this.maplock;
            synchronized (object) {
                for (String string : CacheManager.this.ngrpMap.keySet()) {
                    INgrp iNgrp = (INgrp)CacheManager.this.ngrpMap.get(string);
                    this.println("   " + string + " -> " + iNgrp);
                }
            }
        }

        public final void dumpDiag() {
            this.showAll();
            this.showExternal();
            this.showBjar();
            this.showNgrp();
        }
    }

    private static class JarFileFilter
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            String string2 = string.toUpperCase(Locale.ENGLISH);
            return string2.endsWith(".JAR") || string2.startsWith("CACHE.");
        }

        private JarFileFilter() {
        }
    }
}

