/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.download;

import cerent.util.KDebug;
import com.cisco.ctc.core.download.AbstractPack200Transferer;
import java.beans.PropertyChangeListener;
import java.util.Observer;
import java.util.jar.Pack200;

public abstract class AbstractPacker
extends AbstractPack200Transferer {
    private Pack200.Packer packer = Pack200.newPacker();
    static final long UNLIMITED_SEGMENT_SIZE = -1L;
    protected static KDebug db = new KDebug("AbstractPacker");

    protected AbstractPacker(KDebug kDebug) {
        super(kDebug);
    }

    protected Pack200.Packer getPacker() {
        return this.packer;
    }

    protected final String getPackerProperty(String string) {
        return (String)this.packer.properties().get(string);
    }

    protected final void setPackerProperty(String string, String string2) {
        this.packer.properties().put(string, string2);
        if (db.isFinerEnabled()) {
            this.logFiner("Pack200 packer property set: " + string + "=" + string2);
        }
    }

    public void addObserver(Observer observer) {
        if (this.countObservers() == 0) {
            this.packer.addPropertyChangeListener((PropertyChangeListener)this);
        }
        super.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        super.deleteObserver(observer);
        if (this.countObservers() == 0) {
            this.packer.removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.addObserver(observer);
    }

    public float getEstimatedCompressionRatio() {
        return this.getEstimatedCompressionRatio(false);
    }

    protected long modifyLongNotification(long l) {
        float f = (float)(this.fileInSize * l) / (100.0f * this.getEstimatedCompressionRatio());
        return (long)f;
    }

    public long getRequestedSegmentLimit() {
        String string = prefs.getProperty("ctc.pack200", "segmentsize", "-1");
        long l = -1L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.log("Invalid segment limit: " + string + "...defaulting to default segment size: " + -1L, numberFormatException);
        }
        return l;
    }

    protected void setSegmentLimit(long l) {
        if (l != -1L) {
            this.setPackerProperty("pack.segment.limit", Long.toString(l));
        }
    }

    protected void setRequestedSegmentLimit() {
        this.setSegmentLimit(this.getRequestedSegmentLimit());
    }
}

