/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.download;

import cerent.util.KDebug;
import cerent.util.Preferences;
import com.cisco.ctc.core.download.ITransferer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Observable;

public abstract class AbstractTransferer
extends Observable
implements ITransferer {
    public static final SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    public static final Preferences prefs = Preferences.instance();
    protected KDebug db;
    private ThreadHolder threadHolder;
    protected boolean abort;
    protected boolean aborted;
    private State state = State.INITIAL;

    protected AbstractTransferer(KDebug kDebug) {
        this(null, kDebug);
    }

    protected AbstractTransferer(ThreadHolder threadHolder, KDebug kDebug) {
        if (kDebug == null) {
            throw new IllegalArgumentException("debug instance must be non-null");
        }
        this.db = kDebug;
        this.threadHolder = threadHolder;
    }

    public ThreadHolder getThreadHolder() {
        return this.threadHolder;
    }

    public boolean getAbort() {
        return this.abort;
    }

    public boolean getAborted() {
        return this.aborted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAbort(boolean bl) {
        if (bl && this.abort != bl) {
            this.abort = bl;
            if (this.threadHolder != null) {
                ThreadHolder threadHolder = this.threadHolder;
                synchronized (threadHolder) {
                    Thread thread;
                    Thread thread2 = this.threadHolder.unsynchronizedGetThread();
                    if (thread2 != null && !thread2.equals(thread = Thread.currentThread())) {
                        thread2.interrupt();
                    }
                }
            }
        }
    }

    protected void log(Throwable throwable) {
        KDebug.printStackTrace(throwable);
    }

    protected void log(String string, Throwable throwable) {
        this.db.println(string);
        KDebug.printStackTrace(throwable);
    }

    protected void logAndThrow(RuntimeException runtimeException) throws RuntimeException {
        KDebug.printStackTrace(runtimeException);
        throw runtimeException;
    }

    protected void logAndThrow(String string, RuntimeException runtimeException) throws RuntimeException {
        this.db.println(string);
        KDebug.printStackTrace(runtimeException);
        throw runtimeException;
    }

    protected void logAndThrow(IOException iOException) throws IOException {
        KDebug.printStackTrace(iOException);
        throw iOException;
    }

    protected void logAndThrow(String string, IOException iOException) throws IOException {
        this.db.println(string);
        KDebug.printStackTrace(iOException);
        throw iOException;
    }

    protected void log(String string) {
        this.db.println(string);
    }

    protected void logFiner(String string) {
        this.db.finer(string);
    }

    protected void logFinest(String string) {
        this.db.finest(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void transfer(Object object, Object object2, Object object3) throws IOException {
        Object object4;
        String string;
        Date date;
        block34: {
            Exception exception;
            block33: {
                date = new Date();
                string = sdf.format(date);
                this.logFiner(string + " start transfer...");
                exception = null;
                object4 = this.preTransferInput(object);
                OutputStream outputStream = this.preTransferOutput(object2);
                this.startTransfer((InputStream)object4, outputStream);
                Object var10_11 = null;
                try {
                    this.endTransfer(object3);
                    Object var13_15 = null;
                    if (exception != null) break block33;
                    this.notify(Long.MAX_VALUE);
                }
                catch (Throwable throwable) {
                    Object var13_18 = null;
                    if (exception == null) {
                        this.notify(Long.MAX_VALUE);
                    }
                    this.deleteObservers();
                    throw throwable;
                }
            }
            this.deleteObservers();
            {
                break block34;
                catch (RuntimeException runtimeException) {
                    exception = runtimeException;
                    this.logAndThrow(runtimeException);
                    Object var13_16 = null;
                    if (exception == null) {
                        this.notify(Long.MAX_VALUE);
                    }
                    this.deleteObservers();
                    break block34;
                }
                catch (IOException iOException) {
                    exception = iOException;
                    this.logAndThrow(iOException);
                    Object var13_17 = null;
                    if (exception == null) {
                        this.notify(Long.MAX_VALUE);
                    }
                    this.deleteObservers();
                    break block34;
                }
            }
            {
                catch (RuntimeException runtimeException) {
                    block35: {
                        if (this.getAbort() && Thread.currentThread().isInterrupted()) {
                            this.aborted = true;
                        }
                        this.logAndThrow(runtimeException);
                        Object var10_12 = null;
                        try {
                            this.endTransfer(object3);
                            Object var13_19 = null;
                            if (exception != null) break block35;
                            this.notify(Long.MAX_VALUE);
                        }
                        catch (Throwable throwable) {
                            Object var13_22 = null;
                            if (exception == null) {
                                this.notify(Long.MAX_VALUE);
                            }
                            this.deleteObservers();
                            throw throwable;
                        }
                    }
                    this.deleteObservers();
                    {
                        break block34;
                        catch (RuntimeException runtimeException2) {
                            exception = runtimeException2;
                            this.logAndThrow(runtimeException2);
                            Object var13_20 = null;
                            if (exception == null) {
                                this.notify(Long.MAX_VALUE);
                            }
                            this.deleteObservers();
                            break block34;
                        }
                        catch (IOException iOException) {
                            exception = iOException;
                            this.logAndThrow(iOException);
                            Object var13_21 = null;
                            if (exception == null) {
                                this.notify(Long.MAX_VALUE);
                            }
                            this.deleteObservers();
                            break block34;
                        }
                    }
                }
                catch (IOException iOException) {
                    block36: {
                        exception = iOException;
                        if (this.getAbort() && Thread.currentThread().isInterrupted()) {
                            this.aborted = true;
                        }
                        this.logAndThrow(iOException);
                        Object var10_13 = null;
                        try {
                            this.endTransfer(object3);
                            Object var13_23 = null;
                            if (exception != null) break block36;
                            this.notify(Long.MAX_VALUE);
                        }
                        catch (Throwable throwable) {
                            Object var13_26 = null;
                            if (exception == null) {
                                this.notify(Long.MAX_VALUE);
                            }
                            this.deleteObservers();
                            throw throwable;
                        }
                    }
                    this.deleteObservers();
                    {
                        break block34;
                        catch (RuntimeException runtimeException) {
                            exception = runtimeException;
                            this.logAndThrow(runtimeException);
                            Object var13_24 = null;
                            if (exception == null) {
                                this.notify(Long.MAX_VALUE);
                            }
                            this.deleteObservers();
                            break block34;
                        }
                        catch (IOException iOException2) {
                            exception = iOException2;
                            this.logAndThrow(iOException2);
                            Object var13_25 = null;
                            if (exception == null) {
                                this.notify(Long.MAX_VALUE);
                            }
                            this.deleteObservers();
                            break block34;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block38: {
                    block37: {
                        Object var10_14 = null;
                        try {
                            this.endTransfer(object3);
                            Object var13_27 = null;
                            if (exception != null) break block37;
                            this.notify(Long.MAX_VALUE);
                        }
                        catch (Throwable throwable2) {
                            Object var13_30 = null;
                            if (exception == null) {
                                this.notify(Long.MAX_VALUE);
                            }
                            this.deleteObservers();
                            throw throwable2;
                        }
                    }
                    this.deleteObservers();
                    {
                        break block38;
                        catch (RuntimeException runtimeException) {
                            exception = runtimeException;
                            this.logAndThrow(runtimeException);
                            Object var13_28 = null;
                            if (exception == null) {
                                this.notify(Long.MAX_VALUE);
                            }
                            this.deleteObservers();
                            break block38;
                        }
                        catch (IOException iOException) {
                            exception = iOException;
                            this.logAndThrow(iOException);
                            Object var13_29 = null;
                            if (exception == null) {
                                this.notify(Long.MAX_VALUE);
                            }
                            this.deleteObservers();
                        }
                    }
                }
                throw throwable;
            }
        }
        object4 = new Date();
        string = sdf.format((Date)object4);
        this.logFiner(string + " end transfer..." + (((Date)object4).getTime() - date.getTime()) + " msecs");
    }

    public final void transfer(Object object, Object object2) throws IOException {
        this.transfer(object, object2, null);
    }

    public final void preTransferInput() throws IOException {
        this.preTransferInput(null);
    }

    public final void preTransferOutput() throws IOException {
        this.preTransferOutput(null);
    }

    public final void startTransfer() throws IOException {
        this.startTransfer(null, null);
    }

    public final void endTransfer() throws IOException {
        this.startTransfer(null, null);
    }

    public final void transfer() throws IOException {
        this.transfer(null, null);
    }

    protected final void assertState(boolean bl, String string) {
        if (!bl) {
            this.logAndThrow(new IllegalStateException(string));
        }
    }

    protected final void checkNotState(int n, State state) {
        int n2 = n & this.state.value;
        this.assertState(n2 == 0, "notState cannot overlap the curr. state: " + n2);
        this.state = state;
    }

    protected final void checkState(int n, State state) {
        int n2 = n & this.state.value;
        this.assertState(n2 == n, "Specified state:" + n + " must overlap the current state: " + (Object)((Object)this.state));
    }

    protected void checkPreTransferInputState() {
        this.checkNotState(State.END_TRANSFER.value | State.START_TRANSFER.value | State.PRE_TRANSFER_INPUT.value, State.PRE_TRANSFER_INPUT);
    }

    protected void checkPreTransferOutputState() {
        this.checkNotState(State.END_TRANSFER.value | State.START_TRANSFER.value | State.PRE_TRANSFER_OUTPUT.value, State.PRE_TRANSFER_OUTPUT);
    }

    protected void checkStartTransferState() {
        this.checkNotState(State.END_TRANSFER.value | State.START_TRANSFER.value, State.START_TRANSFER);
    }

    protected void checkEndTransferState() {
        this.checkNotState(State.END_TRANSFER.value, State.END_TRANSFER);
    }

    public float getEstimatedCompressionRatio() {
        return 1.0f;
    }

    protected void streamCopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.streamCopy(inputStream, outputStream, 1024, 1);
    }

    protected final void streamCopy(InputStream inputStream, OutputStream outputStream, int n, int n2) throws IOException {
        if (n2 <= 0) {
            n2 = 1;
        }
        byte[] byArray = new byte[n];
        long l = 0L;
        int n3 = 0;
        int n4 = 0;
        while (!this.abort && (n3 = inputStream.read(byArray, 0, byArray.length)) > 0) {
            outputStream.write(byArray, 0, n3);
            l += (long)n3;
            if (n4 > 0 && n4 % n2 == 0) {
                this.notify(l);
            }
            ++n4;
        }
        if (this.abort && (l == 0L || n3 != 0)) {
            this.aborted = true;
        }
    }

    protected void notify(long l) {
        if (l != Long.MAX_VALUE) {
            l = this.modifyLongNotification(l);
        }
        if (this.db.isFinestEnabled()) {
            this.db.println("notifying of: " + l);
        }
        this.setChanged();
        this.notifyObservers(new Long(l));
    }

    protected long modifyLongNotification(long l) {
        return l;
    }

    public abstract InputStream preTransferInput(Object var1) throws IOException;

    public abstract OutputStream preTransferOutput(Object var1) throws IOException;

    public abstract void startTransfer(InputStream var1, OutputStream var2) throws IOException;

    public abstract void endTransfer(Object var1) throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        INITIAL(0),
        PRE_TRANSFER_INPUT(1),
        PRE_TRANSFER_OUTPUT(2),
        START_TRANSFER(4),
        END_TRANSFER(8);

        public final int value;

        private State(int n2) {
            this.value = n2;
        }
    }

    static class ThreadHolder {
        private Thread currentThread;

        ThreadHolder() {
        }

        public Thread unsynchronizedGetThread() {
            return this.currentThread;
        }

        public void unsynchronizedSetThread(Thread thread) {
            this.currentThread = thread;
        }
    }
}

