/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.download;

import cerent.util.KDebug;
import com.cisco.ctc.core.download.AbstractTransferer;
import com.cisco.ctc.core.download.LazyFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Observer;

public class FileCompositeTransferer
extends AbstractTransferer {
    private AbstractTransferer aSide;
    private AbstractTransferer bSide;
    private InputStream fileis;
    private OutputStream fileos;
    private File intermediateFile;
    private OutputStream useros;
    private boolean aSideTransferFailed;
    private long accumValue;
    private long lastNotifValue;
    protected static KDebug db = new KDebug("FileCompositeTransferer");

    public FileCompositeTransferer(AbstractTransferer abstractTransferer, AbstractTransferer abstractTransferer2, File file) {
        super(abstractTransferer.db);
        this.aSide = abstractTransferer;
        this.bSide = abstractTransferer2;
        this.intermediateFile = file;
    }

    public InputStream preTransferInput(Object object) throws IOException {
        if (db.on()) {
            this.log("Side A - pre-transfer input");
        }
        InputStream inputStream = this.aSide.preTransferInput(object);
        return inputStream;
    }

    public OutputStream preTransferOutput(Object object) throws IOException {
        if (db.on()) {
            this.log("Side A - pre-transfer output: " + this.intermediateFile.getName());
        }
        this.fileos = new LazyFileOutputStream(this.intermediateFile);
        this.aSide.preTransferOutput(this.fileos);
        if (db.on()) {
            this.log("Side B - pre-transfer output");
        }
        OutputStream outputStream = this.bSide.preTransferOutput(object);
        return outputStream;
    }

    public void startTransfer(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            if (db.on()) {
                this.log("Side A - start transfer");
            }
            this.aSide.startTransfer(inputStream, this.fileos);
            this.useros = outputStream;
        }
        catch (IOException iOException) {
            this.aSideTransferFailed = true;
            this.logAndThrow(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endTransfer(Object object) throws IOException {
        IOException iOException;
        block12: {
            iOException = null;
            try {
                block13: {
                    try {
                        try {
                            if (db.on()) {
                                this.log("Side A - end transfer");
                            }
                            this.aSide.endTransfer(object);
                            this.accumValue = this.lastNotifValue;
                            if (db.on()) {
                                this.log("Side B - pre-transfer input");
                            }
                            this.bSide.preTransferInput(this.intermediateFile);
                            if (db.on()) {
                                this.log("Side B - start transfer");
                            }
                            this.bSide.startTransfer(this.fileis, this.useros);
                        }
                        catch (IOException iOException2) {
                            this.log(iOException2);
                            iOException = iOException2;
                            Object var5_4 = null;
                            if (db.on()) {
                                this.log("Side B - end transfer");
                            }
                            this.bSide.endTransfer(object);
                            break block12;
                        }
                        Object var5_3 = null;
                        if (!db.on()) break block13;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        if (db.on()) {
                            this.log("Side B - end transfer");
                        }
                        this.bSide.endTransfer(object);
                        throw throwable;
                    }
                    this.log("Side B - end transfer");
                }
                this.bSide.endTransfer(object);
            }
            catch (IOException iOException3) {
                if (iOException == null) break block12;
                iOException = iOException3;
            }
        }
        if (iOException != null) {
            IOException iOException4 = iOException;
            iOException = null;
            throw iOException;
        }
    }

    public void addObserver(Observer observer) {
        this.aSide.addObserver(observer);
        this.bSide.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.aSide.deleteObserver(observer);
        this.bSide.deleteObserver(observer);
    }

    protected long modifyLongNotification(long l) {
        this.lastNotifValue = l;
        return this.accumValue + l;
    }

    public float getEstimatedCompressionRatio() {
        Float f = Float.valueOf(this.aSide.getEstimatedCompressionRatio());
        if ((double)f.floatValue() == 1.0) {
            f = Float.valueOf(this.bSide.getEstimatedCompressionRatio());
        }
        return f.floatValue();
    }
}

