/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.download;

import cerent.util.KDebug;
import com.cisco.ctc.core.download.AbstractTransferer;
import com.cisco.ctc.core.download.AbstractUnpacker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarOutputStream;

public class FilePack200Unpacker
extends AbstractUnpacker {
    protected File fileIn;
    protected File fileOut;
    protected InputStream is;
    protected JarOutputStream jos;
    protected static KDebug db = new KDebug("FilePack200Unpacker");

    public FilePack200Unpacker(InputStream inputStream, File file) {
        this(inputStream, file, db);
    }

    public FilePack200Unpacker(InputStream inputStream, File file, KDebug kDebug) {
        this(file, kDebug);
        this.is = inputStream;
    }

    public FilePack200Unpacker(File file) {
        this(file, db);
    }

    public FilePack200Unpacker(File file, KDebug kDebug) {
        this((File)null, file, kDebug);
    }

    public FilePack200Unpacker(File file, File file2) {
        this(file, file2, db);
    }

    public FilePack200Unpacker(File file, File file2, KDebug kDebug) {
        super(kDebug);
        this.fileIn = file;
        this.fileOut = file2;
    }

    public JarOutputStream getJarOutputStream() {
        return this.jos;
    }

    public InputStream preTransferInput(Object object) throws IOException {
        this.checkPreTransferInputState();
        if (object instanceof File) {
            File file = (File)object;
            this.fileInSize = file.length();
            this.is = new FileInputStream(file);
        } else if (object instanceof InputStream) {
            this.is = (InputStream)object;
        } else if (object == null && this.is == null) {
            this.fileInSize = this.fileIn.length();
            this.is = new FileInputStream(this.fileIn);
        } else if (this.is == null || object != null) {
            throw new IllegalArgumentException("cannot handle arg: " + (object == null ? "null" : object.getClass().getName()));
        }
        return this.is;
    }

    public OutputStream preTransferOutput(Object object) throws IOException {
        this.checkPreTransferOutputState();
        FileOutputStream fileOutputStream = new FileOutputStream(this.fileOut);
        this.jos = new JarOutputStream(fileOutputStream);
        return this.getJarOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void startTransfer(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.checkStartTransferState();
        AbstractTransferer.ThreadHolder threadHolder2 = this.getThreadHolder();
        try {
            try {
                AbstractTransferer.ThreadHolder threadHolder3 = threadHolder2;
                // MONITORENTER : threadHolder3
                threadHolder2.unsynchronizedSetThread(Thread.currentThread());
                // MONITOREXIT : threadHolder3
                if (db.on()) {
                    db.println("Pack 200 unpacking..." + this.is.getClass().getName());
                }
                if (this.is != null) {
                    this.getUnpacker().unpack(this.is, this.jos);
                } else {
                    this.getUnpacker().unpack(this.fileIn, this.jos);
                }
                threadHolder3 = threadHolder2;
                // MONITORENTER : threadHolder3
                threadHolder2.unsynchronizedSetThread(null);
                // MONITOREXIT : threadHolder3
            }
            catch (IOException iOException) {
                db.println("got Pack200 IO exception: " + iOException.getClass().getName());
                if (!this.abort) throw iOException;
                this.aborted = true;
                Object var8_7 = null;
                AbstractTransferer.ThreadHolder threadHolder = threadHolder2;
                // MONITORENTER : threadHolder
                threadHolder2.unsynchronizedSetThread(null);
                // MONITOREXIT : threadHolder
                return;
            }
            Object var8_6 = null;
            AbstractTransferer.ThreadHolder threadHolder = threadHolder2;
            // MONITORENTER : threadHolder
            threadHolder2.unsynchronizedSetThread(null);
            // MONITOREXIT : threadHolder
            return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            AbstractTransferer.ThreadHolder threadHolder = threadHolder2;
            // MONITORENTER : threadHolder
            threadHolder2.unsynchronizedSetThread(null);
            // MONITOREXIT : threadHolder
            throw throwable;
        }
    }

    public void endTransfer(Object object) throws IOException {
        this.checkEndTransferState();
        this.jos.close();
    }
}

