/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.download;

import cerent.util.KDebug;
import com.cisco.ctc.core.download.AbstractTransferer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;

public class StreamDecompressor
extends AbstractTransferer {
    private final boolean gzipMode;
    protected File fileIn;
    protected File fileOut;
    protected InputStream is;
    protected OutputStream os;
    protected static KDebug db = new KDebug("StreamDecompressor");

    public StreamDecompressor(File file) {
        this(null, file, false);
    }

    public StreamDecompressor(InputStream inputStream, File file) {
        this(null, file, false);
        this.is = inputStream;
    }

    public StreamDecompressor(File file, boolean bl) {
        this(null, file, bl);
    }

    public StreamDecompressor(File file, File file2, boolean bl) {
        super(db);
        this.fileIn = file;
        this.fileOut = file2;
        this.gzipMode = bl;
    }

    public InputStream preTransferInput(Object object) throws IOException {
        this.checkPreTransferInputState();
        if (object instanceof File) {
            File file = (File)object;
            InputStream inputStream = new FileInputStream(file);
            inputStream = this.getInputStream(inputStream);
        } else if (object instanceof GZIPInputStream) {
            this.is = (GZIPInputStream)object;
        } else if (object instanceof InputStream) {
            this.is = this.getInputStream((InputStream)object);
        } else if (this.is != null) {
            this.is = this.getInputStream(this.is);
        } else if (object != null) {
            throw new IllegalArgumentException("cannot handle arg: " + (object == null ? "null" : object.getClass().getName()));
        }
        return this.is;
    }

    protected InputStream getInputStream(InputStream inputStream) throws IOException {
        return this.gzipMode ? new GZIPInputStream(inputStream) : inputStream;
    }

    public OutputStream preTransferOutput(Object object) throws IOException {
        this.checkPreTransferOutputState();
        this.os = object instanceof OutputStream ? (OutputStream)object : new FileOutputStream(this.fileOut);
        return this.os;
    }

    public void startTransfer(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.checkStartTransferState();
        if (db.on()) {
            db.println("transfer decompressing..." + inputStream.getClass().getName());
        }
        this.streamCopy(inputStream, outputStream);
    }

    public void endTransfer(Object object) throws IOException {
        this.checkEndTransferState();
        this.is.close();
        if (this.os != null) {
            this.os.close();
        }
    }
}

