/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.launcher;

import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import com.cisco.ctc.core.cache.CacheManager;
import com.cisco.ctc.core.launcher.Launcher;
import com.cisco.ctc.core.launcher.LauncherSettingsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CacheSettings
extends JPanel
implements ActionListener,
ListSelectionListener {
    private final JButton bDelete = new JButton("Delete");
    private final JButton bAdd = new JButton("Add...");
    private final JButton bUp = new JButton("Move Up");
    private final JButton bDown = new JButton("Move Down");
    private final JButton bDelCache = new JButton("Delete Cache");
    private JList list;
    private DefaultListModel listModel;
    private boolean dirty = false;
    private boolean cacheDeleted = false;
    private String[] changedDirList = null;
    private LauncherSettingsDialog parent = null;

    public CacheSettings(LauncherSettingsDialog launcherSettingsDialog) {
        this.parent = launcherSettingsDialog;
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel("Cache Directory List:"), "North");
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addButton(jPanel, this.bAdd);
        this.addButton(jPanel, this.bDelete);
        this.addButton(jPanel, this.bUp);
        this.addButton(jPanel, this.bDown);
        jPanel.add(Box.createHorizontalStrut(3));
        this.addButton(jPanel, this.bDelCache);
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.getSelectionModel().addListSelectionListener(this);
        this.load();
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.sync();
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "East");
    }

    private void addButton(JComponent jComponent, JButton jButton) {
        jComponent.add(jButton);
        jButton.addActionListener(this);
    }

    private void sync() {
        int n = this.list.getSelectedIndex();
        this.bDelete.setEnabled(this.listModel.size() > 1);
        this.bUp.setEnabled(n != 0);
        this.bDown.setEnabled(n < this.listModel.size() - 1);
        this.bDelCache.setEnabled(n == 0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = this.list.getSelectedIndex();
        if (object == this.bAdd) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setMultiSelectionEnabled(false);
            int n2 = jFileChooser.showDialog(this, "Add Directory");
            if (n2 == 0) {
                File file = jFileChooser.getSelectedFile();
                try {
                    String string = file.getCanonicalPath();
                    if (!this.listModel.contains(string)) {
                        this.listModel.addElement(string);
                        this.setDirty(true);
                    }
                }
                catch (IOException iOException) {}
            }
        } else if (object == this.bDelCache) {
            int n3;
            Object[] objectArray = new Object[]{"Yes", "No"};
            String string = KErrorMsg.getString(KEMC.WID_DELETE_CTC_CACHE);
            if (this.listModel.size() > 1) {
                string = string + "\nOnly the content of the first directory will be deleted.";
            }
            if ((n3 = JOptionPane.showOptionDialog(this, string + "\n\nIs it OK to continue?", "Delete CTC Cache", 0, 2, null, objectArray, objectArray[1])) == 0) {
                Launcher.instance().deleteCache();
                this.cacheDeleted = true;
            }
        } else {
            Object e = this.listModel.remove(n);
            if (object == this.bUp) {
                this.listModel.add(--n, e);
            } else if (object == this.bDown) {
                this.listModel.add(++n, e);
            } else if (n > 0) {
                --n;
            }
            this.list.setSelectedIndex(n);
            this.setDirty(true);
        }
        this.sync();
    }

    public boolean isDirty() {
        return this.dirty || this.cacheDeleted;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
        this.parent.setDirty(bl);
    }

    public void load() {
        String[] stringArray;
        for (String string : stringArray = CacheManager.instance().getCacheDirList()) {
            this.listModel.addElement(string);
        }
        if (stringArray.length > 0) {
            this.list.setSelectedIndex(0);
        }
        this.setDirty(false);
    }

    public int store() throws IOException {
        this.changedDirList = new String[this.listModel.size()];
        for (int i = 0; i < this.changedDirList.length; ++i) {
            this.changedDirList[i] = (String)this.listModel.getElementAt(i);
        }
        Launcher.instance().setCacheDirList(this.changedDirList);
        return 0;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.sync();
    }
}

