/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.core.launcher;

import cerent.util.CtcRuntime;
import cerent.util.Preferences;
import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.CoreVersionUtil;
import com.cisco.ctc.core.JreReqs;
import com.cisco.ctc.core.JreVersion;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JreProperties {
    private static final String DOT = ".";
    private static final String PREF_PATH = "ctc.launcher.jre";
    private static final String PREF_JRE_PATH = "path." + CtcRuntime.OS_KEY + ".";
    private static final String PREF_CTC_JRE = "ctc.";
    private static final String PREF_MAX_HEAP = "heap.max";
    private static final String PREF_PERM_SIZE = "perm.max";
    private static final int DEFAULT_MAX_HEAP = 256;
    public static final int LOWBOUND_MAX_HEAP = 128;
    public static final int HIGHBOUND_MAX_HEAP = 2048;
    private static final int DEFAULT_MAX_PERM = 64;
    private static final int LOWBOUND_MAX_PERM = 64;
    private static final int HIGHBOUND_MAX_PERM = 1024;
    private static final int NO_MAX_PERM_SPECIFY = -1;
    private int maxHeap;
    private int maxPerm;
    private static JreProperties instance = new JreProperties();
    private Preferences preferences;

    public static JreProperties instance() {
        return instance;
    }

    private JreProperties() {
        String string = Preferences.getDefaultLauncherPrefsFileName();
        this.preferences = Preferences.instance(string);
        this.maxHeap = this.preferences.getInt(PREF_PATH, PREF_MAX_HEAP, 256);
        this.maxPerm = this.preferences.getInt(PREF_PATH, PREF_PERM_SIZE, -1);
        if (this.maxHeap < 128) {
            this.maxHeap = 128;
        } else if (this.maxHeap > 2048) {
            this.maxHeap = 2048;
        }
        if (this.maxPerm == -1) {
            this.maxPerm = this.maxHeap / 4;
        }
        if (this.maxPerm < 64) {
            this.maxPerm = 64;
        } else if (this.maxPerm > 1024) {
            this.maxPerm = 1024;
        }
    }

    public int getMaxHeap() {
        return this.maxHeap;
    }

    public void setMaxHeap(int n) {
        if (n < 128) {
            n = 128;
        } else if (n > 2048) {
            n = 2048;
        }
        if (n != this.maxHeap) {
            this.maxHeap = n;
            this.preferences.setInt(PREF_PATH, PREF_MAX_HEAP, this.maxHeap);
        }
    }

    private String getCtcJrePropertyName(Comparable comparable) {
        return PREF_CTC_JRE + CoreVersionUtil.instance().toString(comparable);
    }

    public void setCtcJreVersion(Comparable comparable, JreVersion jreVersion) {
        if (jreVersion != null) {
            this.preferences.setProperty(PREF_PATH, this.getCtcJrePropertyName(comparable), jreVersion.getVersion());
        } else {
            this.preferences.removeProperty(PREF_PATH, PREF_CTC_JRE + comparable.toString());
        }
    }

    public JreVersion getCtcJreVersion(Comparable comparable) {
        String string = this.preferences.getProperty(PREF_PATH, this.getCtcJrePropertyName(comparable), null);
        if (string != null) {
            return new JreVersion(string);
        }
        return null;
    }

    public List<JreVersion> getJreVersions(JreReqs jreReqs) {
        JreVersion jreVersion;
        LinkedList<JreVersion> linkedList = new LinkedList<JreVersion>();
        Map<JreVersion, String> map = this.getJreDirMap();
        if (!map.containsKey(jreVersion = JreVersion.USER_VERSION)) {
            String string = this.getCurrentJavaInstallDirectory();
            map.put(jreVersion, string);
            this.setJrePath(jreVersion, string);
        }
        for (JreVersion jreVersion2 : map.keySet()) {
            if (!jreReqs.isTested(jreVersion2)) continue;
            if (jreReqs.RECOMMENDED_VERSION.equals(jreVersion2)) {
                linkedList.addFirst(jreVersion2);
                continue;
            }
            linkedList.addLast(jreVersion2);
        }
        return linkedList;
    }

    public String getCurrentJavaInstallDirectory() {
        String string = System.getProperty("java.home");
        File file = new File(string);
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        return string;
    }

    public String getCurrentJreVersionIfNotMinimum(JreReqs jreReqs) {
        String string = null;
        JreVersion jreVersion = JreVersion.USER_VERSION;
        if (jreReqs.meetsReqs(jreVersion)) {
            string = this.getCurrentJavaInstallDirectory();
        }
        return string;
    }

    public void setJrePath(JreVersion jreVersion, String string) {
        if (string != null) {
            this.preferences.setProperty(PREF_PATH, PREF_JRE_PATH + jreVersion, string);
        } else {
            this.preferences.removeProperty(PREF_PATH, PREF_JRE_PATH + jreVersion);
        }
    }

    public String getJrePath(JreVersion jreVersion) {
        String string = this.preferences.getProperty(PREF_PATH, PREF_JRE_PATH + jreVersion, null);
        return string;
    }

    public ArrayList<String> getJreArgs(ArrayList<String> arrayList, JreVersion jreVersion, Comparable comparable) {
        arrayList.add("-Xmx" + this.maxHeap + "m");
        arrayList.add("-XX:MaxPermSize=" + this.maxPerm + "m");
        return arrayList;
    }

    public Map<Comparable, JreVersion> getCtcJreMap() {
        Map<String, String> map = this.preferences.getPropertyMap(PREF_PATH, PREF_CTC_JRE);
        TreeMap<Comparable, JreVersion> treeMap = new TreeMap<Comparable, JreVersion>();
        for (String string : map.keySet()) {
            try {
                Comparable comparable = CoreVersionUtil.instance().createVersionOrdinal(ClassLoaderEnum.SYSTEM, (Comparable)((Object)string));
                JreVersion jreVersion = new JreVersion(map.get(string));
                treeMap.put(comparable, jreVersion);
            }
            catch (Exception exception) {}
        }
        return treeMap;
    }

    public Map<JreVersion, String> getJreDirMap() {
        Map<String, String> map = this.preferences.getPropertyMap(PREF_PATH, PREF_JRE_PATH);
        TreeMap<JreVersion, String> treeMap = new TreeMap<JreVersion, String>();
        for (String string : map.keySet()) {
            JreVersion jreVersion = new JreVersion(string);
            treeMap.put(jreVersion, map.get(string));
        }
        return treeMap;
    }

    public void save() throws FileNotFoundException, InterruptedIOException, IOException {
        this.preferences.store();
    }
}

