/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.sot;

import cerent.util.CtcRuntime;
import cerent.util.IDebugDiag;
import cerent.util.KDebug;
import cerent.util.Preferences;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Set;

public class LimitXpSocketsUtil {
    private static final Preferences prefs = Preferences.instance();
    private static final int MAX_DISTINCT_ADDR_CONNECTS = prefs.getInt("ctc", "xp.socketlimit.size", 10);
    private static final boolean forceLimit = prefs.getBoolean("ctc", "xp.socketlimit", false);
    private static final boolean totalLimit = prefs.getBoolean("ctc", "xp.socketlimit.total", true);
    private static HashMap<InetAddress, IntHolder> map = new HashMap();
    static Debug db = new Debug("LimitXpSocketsUtil");
    private static int numDistinct = 0;
    private static int numRequests = 0;
    private static int numTotal = 0;
    private static int maxNumTotal = 0;

    public static boolean isNeededForThisOs() {
        return CtcRuntime.hasWindowsSocketCreateLimit || forceLimit;
    }

    private static String noHost(SocketAddress socketAddress) {
        return LimitXpSocketsUtil.noHost(((InetSocketAddress)socketAddress).toString());
    }

    private static String noHost(String string) {
        int n = string.indexOf(47);
        String string2 = n >= 0 ? string.substring(n + 1) : string;
        return string2;
    }

    public static IntHolder acquireConnectResource(SocketAddress socketAddress, int n) throws IOException {
        return totalLimit ? LimitXpSocketsUtil._acquireConnectResourceTotal(socketAddress, n) : LimitXpSocketsUtil._acquireConnectResource(socketAddress, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IntHolder _acquireConnectResourceTotal(SocketAddress socketAddress, int n) throws IOException {
        long l;
        int n2 = n / 1000;
        int n3 = 0;
        boolean bl = false;
        long l2 = 0L;
        if (db.isFinestEnabled()) {
            db.finest(LimitXpSocketsUtil.noHost(socketAddress) + " starting to acquire w/ TO " + n2 + " secs");
        }
        HashMap<InetAddress, IntHolder> hashMap = map;
        synchronized (hashMap) {
            ++numRequests;
            while (numTotal >= MAX_DISTINCT_ADDR_CONNECTS) {
                try {
                    if (!bl) {
                        l2 = System.currentTimeMillis();
                        db.incrementNumWaits();
                        bl = true;
                    }
                    map.wait();
                }
                catch (InterruptedException interruptedException) {
                    IOException iOException = new IOException("got interrupted exception in acquireConnectResource()");
                    iOException.initCause(interruptedException);
                    throw iOException;
                }
            }
            n3 = ++numTotal;
            if (numTotal > maxNumTotal) {
                maxNumTotal = numTotal;
            }
        }
        long l3 = l = l2 == 0L ? 0L : System.currentTimeMillis();
        if (db.isFinestEnabled()) {
            db.finest(LimitXpSocketsUtil.noHost(socketAddress) + (bl ? " WAITED " + (l - l2) + " msecs to " : "") + " acquire w/ TO " + n2 + " secs: # outstanding requests: " + n3);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IntHolder _acquireConnectResource(SocketAddress socketAddress, int n) throws IOException {
        int n2 = n / 1000;
        InetAddress inetAddress = ((InetSocketAddress)socketAddress).getAddress();
        if (db.isFinestEnabled()) {
            db.finest(LimitXpSocketsUtil.noHost(socketAddress) + "acquire w/ TO " + n2 + " secs: # distinct addr. oustanding requests: " + numDistinct);
        }
        IntHolder intHolder = null;
        int n3 = 0;
        HashMap<InetAddress, IntHolder> hashMap = map;
        synchronized (hashMap) {
            ++numRequests;
            intHolder = map.get(inetAddress);
            if (intHolder == null) {
                intHolder = new IntHolder(0);
                map.put(inetAddress, intHolder);
            } else {
                n3 = intHolder.i;
            }
            boolean bl = false;
            if (n3 == 0 && numDistinct >= MAX_DISTINCT_ADDR_CONNECTS) {
                if (LimitXpSocketsUtil.db.on) {
                    db.println("(wait) # distinct: " + numDistinct);
                }
                bl = true;
                db.incrementNumWaits();
                do {
                    try {
                        map.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        IOException iOException = new IOException("got interrupted exception in acquireConnectResource()");
                        iOException.initCause(interruptedException);
                        throw iOException;
                    }
                    if (!db.isFinerEnabled()) continue;
                    db.println("(awake)");
                } while (numDistinct >= MAX_DISTINCT_ADDR_CONNECTS);
                if (LimitXpSocketsUtil.db.on) {
                    db.println(LimitXpSocketsUtil.noHost(socketAddress) + (bl ? " WAITED " : "") + " connecting w/ TO " + n2 + " secs: # distinct addr. oustanding requests: " + numDistinct);
                }
            }
            if (n3 == 0) {
                ++numDistinct;
            }
            intHolder.i = ++n3;
        }
        return intHolder;
    }

    public static void releaseConnectResource(IntHolder intHolder, SocketAddress socketAddress, int n) {
        if (totalLimit) {
            LimitXpSocketsUtil._releaseConnectResourceTotal(intHolder, socketAddress, n);
        } else {
            LimitXpSocketsUtil._releaseConnectResource(intHolder, socketAddress, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _releaseConnectResourceTotal(IntHolder intHolder, SocketAddress socketAddress, int n) {
        int n2 = n / 1000;
        int n3 = 0;
        HashMap<InetAddress, IntHolder> hashMap = map;
        synchronized (hashMap) {
            n3 = --numTotal;
            map.notify();
        }
        if (db.isFinestEnabled()) {
            db.finest(LimitXpSocketsUtil.noHost(socketAddress) + " release w/ TO " + n2 + " secs: # outstanding requests " + n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _releaseConnectResource(IntHolder intHolder, SocketAddress socketAddress, int n) {
        int n2 = n / 1000;
        if (db.isFinestEnabled()) {
            db.finest(LimitXpSocketsUtil.noHost(socketAddress) + "release w/ TO " + n2 + " secs: # distinct addr. outstanding requests (total - addr. in question): " + numDistinct + " - " + intHolder.i);
        }
        HashMap<InetAddress, IntHolder> hashMap = map;
        synchronized (hashMap) {
            int n3 = --intHolder.i;
            if (n3 <= 0 && --numDistinct < MAX_DISTINCT_ADDR_CONNECTS) {
                if (LimitXpSocketsUtil.db.on) {
                    db.println("(notify) # distinct now: " + numDistinct);
                }
                map.notify();
            }
        }
    }

    public static class Debug
    extends KDebug
    implements IDebugDiag {
        private long numIOExceptions;
        private long numWaits;
        private long numSamples;
        private long sumWait;
        private long maxWait;
        private long sumConnect;
        private long maxConnect;

        public Debug(String string) {
            super(string);
        }

        void incrementNumWaits() {
            ++this.numWaits;
        }

        void reportElapsedTimes(IOException iOException, long l, long l2, long l3) {
            if (iOException != null) {
                ++this.numIOExceptions;
            } else {
                ++this.numSamples;
                long l4 = l2 - l;
                long l5 = l3 - l;
                this.sumWait += l4;
                if (l4 > this.maxWait) {
                    this.maxWait = l4;
                }
                this.sumConnect += l5;
                if (l5 > this.maxConnect) {
                    this.maxConnect = l5;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpDiag() {
            int n = 0;
            HashMap hashMap = map;
            synchronized (hashMap) {
                this.println("count size: " + MAX_DISTINCT_ADDR_CONNECTS);
                this.println("force limit: " + forceLimit);
                this.println("total limit (approach): " + totalLimit);
                this.println("total # of IOExceptions: " + this.numIOExceptions);
                this.println("total # of requests: " + numRequests);
                this.println("total # of requests that had a wait: " + this.numWaits);
                if (numTotal > 0) {
                    this.println("total # of outstanding requests: " + numTotal);
                }
                this.println("max total # of outstanding requests: " + maxNumTotal);
                if (this.numSamples > 0L) {
                    this.println("avg. wait time msecs: " + this.sumWait / this.numSamples);
                }
                this.println("max wait time msecs: " + this.maxWait);
                if (this.numSamples > 0L) {
                    this.println("avg. total connect time msecs: " + this.sumConnect / this.numSamples);
                }
                this.println("max total connect time msecs: " + this.maxConnect);
                this.println("unique addr. request map dump:");
                Set set = map.keySet();
                for (InetAddress inetAddress : set) {
                    IntHolder intHolder = (IntHolder)map.get(inetAddress);
                    n += intHolder.i;
                    if (intHolder.i <= 0) continue;
                    this.println("  " + inetAddress + " - " + intHolder.i);
                }
            }
            this.println("total # connect requests:" + n);
        }
    }

    public static class IntHolder {
        public int i;

        public IntHolder(int n) {
            this.i = n;
        }
    }
}

