/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.sot;

import cerent.util.KDebug;
import cerent.util.Preferences;
import com.cisco.sot.LimitXpSocketsUtil;
import com.cisco.sot.NioBufferHelper;
import com.cisco.sot.SotSocket;
import com.cisco.sot.SotSocketImpl;
import com.cisco.sot.Ssh;
import com.cisco.sot.Tl1Buffer;
import com.cisco.sot.Tl1TunnelAddr;
import com.cisco.sot.Tl1TunnelFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.Observable;

public class Tl1Tunnel
extends Observable {
    public static final boolean LOOPBACK = false;
    private static final int MUX_BUFFER_SIZE = 1280;
    private static final int MAX_CHANNELS = 32;
    private static final int FIRST_RETRY_INTERVAL = 2000;
    private static final int RETRY_INTERVAL = 20000;
    private static final int TUNNEL_RESET_ID = -1;
    private static KDebug dbg = new KDebug("Tl1Tunnel");
    private static int maxmux;
    private Tl1TunnelAddr address;
    private int openTunnelTimeout;
    private Socket socket;
    private SocketChannel channel;
    private InetAddress pneIp;
    private SelectionKey selKey;
    private Tl1Buffer tl1Buffer;
    private int selKeyReqFlags = 0;
    private Selector selector;
    private final SotSocketImpl[] channels = new SotSocketImpl[32];
    private int nbChannels = 0;
    private int rrIndex = 0;
    private long totSockCount = 0L;
    private ByteBuffer muxbb;
    private TtState state = NOTINITED;
    private String failDesc = null;
    private boolean acceptorTunnel = false;
    private boolean wfActUserReply = false;
    private String actUserReply = null;
    private IOException lastIoExc = null;
    private boolean closedByUser;
    private int retries = 0;
    private long rxBytes;
    private long txBytes;
    private static final int MIN_TX_PAYLOAD_SIZE = 256;
    private static final int TX_PAYLOAD_PROBE_DELTA = 256;
    private int maxTxPayloadSize;
    private static final int ID_DATA_ECHO = -320017172;
    private int nextPayloadProbeSize;
    private static final String PREFS_PREFIX = "ctc.sotl1";
    private static final String PREFS_TX_PAYLOAD_SZ = "payloadsize";
    private LinkedList closeRqPending = new LinkedList();
    public static final TtState NOTINITED;
    public static final TtState OPENING;
    public static final TtState OPEN;
    public static final TtState OPENFAILED;
    public static final TtState CLOSING;
    public static final TtState RETRYPENDING;
    public static final TtState CLOSED;

    protected Tl1Tunnel() {
        this.muxbb = ByteBuffer.allocate(1280);
    }

    protected SocketChannel getChannel() {
        return this.channel;
    }

    public Tl1TunnelAddr getAddress() {
        return this.address;
    }

    protected Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return this.createSocket(inetAddress, n, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Socket createSocket(InetAddress inetAddress, int n, int n2) throws IOException {
        if (this.state == OPEN) {
            SotSocketImpl sotSocketImpl = null;
            Object object = this.channels;
            synchronized (this.channels) {
                for (int i = 0; i < this.channels.length; ++i) {
                    if (this.channels[i] != null) continue;
                    int n3 = (int)((++this.totSockCount << 16) + (long)i + 1L);
                    this.channels[i] = sotSocketImpl = new SotSocketImpl(this, n3);
                    ++this.nbChannels;
                    break;
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                if (sotSocketImpl == null) {
                    throw new IOException("The maximum number of sockets for this tunnel, " + this.channels.length + ", has been reached.");
                }
                object = new SotSocket(sotSocketImpl);
                ((Socket)object).connect(new InetSocketAddress(inetAddress, n), n2);
                this.sendUpdates();
                return object;
            }
        }
        throw new IOException("The tunnel is not in the OPEN state:" + this.state.toString() + ".");
    }

    private SotSocketImpl getSocket(int n) {
        int n2 = (n & 0xFFFF) - 1;
        if (n2 < 0 || n2 >= this.channels.length) {
            return null;
        }
        SotSocketImpl sotSocketImpl = this.channels[n2];
        if (sotSocketImpl == null || sotSocketImpl.getLocChnId() != n) {
            return null;
        }
        return sotSocketImpl;
    }

    public void close() {
        this.closedByUser = true;
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        dbg.println("Tunnel closing...");
        this.setState(CLOSING);
        SotSocketImpl[] sotSocketImplArray = this.channels;
        synchronized (this.channels) {
            for (int i = 0; i < this.channels.length; ++i) {
                SotSocketImpl sotSocketImpl = this.channels[i];
                if (sotSocketImpl == null) continue;
                try {
                    sotSocketImpl.close();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.nbChannels = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Tl1TunnelFactory.instance().selectCallback(this);
            return;
        }
    }

    public InetAddress getPneIp() {
        return this.pneIp;
    }

    public boolean canTunnelFor(InetAddress inetAddress) {
        return !this.acceptorTunnel && this.pneIp != null && this.pneIp.equals(inetAddress);
    }

    protected synchronized void openTunnel(Tl1TunnelAddr tl1TunnelAddr, int n, Selector selector) throws IOException {
        this.address = tl1TunnelAddr;
        this.openTunnelTimeout = n;
        this.selector = selector;
        this.openTunnel(false);
    }

    private synchronized void openTunnel(boolean bl) throws IOException {
        this.channel = SocketChannel.open();
        this.socket = this.channel.socket();
        this.channel.configureBlocking(false);
        this.lastIoExc = null;
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.address.ip, this.address.getPort());
        Selector selector = Selector.open();
        this.traceActivity("Connecting to " + inetSocketAddress);
        IOException iOException = null;
        LimitXpSocketsUtil.IntHolder intHolder = null;
        if (LimitXpSocketsUtil.isNeededForThisOs()) {
            intHolder = LimitXpSocketsUtil.acquireConnectResource(inetSocketAddress, this.openTunnelTimeout);
        }
        try {
            if (!this.channel.connect(inetSocketAddress)) {
                this.channel.register(selector, 8, this);
                selector.select(this.openTunnelTimeout);
                this.channel.finishConnect();
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (LimitXpSocketsUtil.isNeededForThisOs()) {
            LimitXpSocketsUtil.releaseConnectResource(intHolder, inetSocketAddress, this.openTunnelTimeout);
        }
        if (iOException != null) {
            throw iOException;
        }
        this.traceActivity("Connected");
        selector.close();
        this.tl1Buffer = new Tl1Buffer(this.channel, this.address);
        this.setState(OPENING);
        Tl1TunnelFactory.instance().selectCallback(this);
        if (this.address.gneTid != null) {
            String string = "ACT-USER:" + this.address.gneTid + ":" + this.address.gneUsername + ":1::" + this.address.gnePassword + ";";
            this.tl1Buffer.loadOutBuffer(string);
            this.setWritable();
            this.traceActivity("ACT-USER:" + this.address.gneTid + ":" + this.address.gneUsername + ":1::" + this.address.gnePassword.replaceAll(".", "*") + ";");
            this.wfActUserReply = true;
            try {
                this.wait(this.openTunnelTimeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.lastIoExc != null) {
                dbg.println("Waiting for ACT-USER failed:" + this.lastIoExc.getMessage());
                throw this.lastIoExc;
            }
            if (this.actUserReply == null) {
                if (bl) {
                    this.dispose();
                } else {
                    this.close();
                }
                throw new IOException("The connection timed out.");
            }
            if (this.actUserReply.indexOf("COMPLD") < 0) {
                throw new IOException("The TL1 connection was rejected by the GNE.");
            }
        }
        this.traceActivity("Opening tunnel to remote ENE TID=" + this.address.pneTid);
        this.muxbb.clear();
        int n = 0;
        if (!this.address.isDataBase64()) {
            n = -1;
        }
        Ssh.openTunnelRq(this.muxbb, n);
        this.muxbb.flip();
        this.tl1Buffer.loadOutBuffer(this.muxbb, true);
        this.setWritable();
        while (this.state == OPENING) {
            try {
                this.wait(this.openTunnelTimeout);
                if (this.state != OPENING) continue;
                if (bl) {
                    this.dispose();
                } else {
                    this.close();
                }
                throw new IOException("The connection timed out.");
            }
            catch (InterruptedException interruptedException) {
            }
        }
        if (this.state != OPEN) {
            if (bl) {
                this.dispose();
            } else {
                this.close();
            }
            if (this.failDesc != null) {
                throw new IOException("The tunnel establishment with the ENE failed.\n" + this.failDesc);
            }
            throw new IOException("The tunnel establishment with the ENE failed.");
        }
        int n2 = Preferences.instance().getInt(PREFS_PREFIX, PREFS_TX_PAYLOAD_SZ, 0);
        if (n2 > 0) {
            if (n2 < 100) {
                n2 = 100;
            } else if (n2 > 1280) {
                n2 = 1280;
            }
            this.maxTxPayloadSize = n2;
        } else {
            this.maxTxPayloadSize = 256;
            this.nextPayloadProbeSize = this.maxTxPayloadSize + 256;
            this.setWritable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSocket(SotSocketImpl sotSocketImpl) {
        int n = (sotSocketImpl.getLocChnId() & 0xFFFF) - 1;
        SotSocketImpl[] sotSocketImplArray = this.channels;
        synchronized (this.channels) {
            if (this.channels[n] == sotSocketImpl) {
                this.channels[n] = null;
                --this.nbChannels;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.sendUpdates();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendChnClose(int n, boolean bl) {
        LinkedList linkedList = this.closeRqPending;
        synchronized (linkedList) {
            this.closeRqPending.add(new Integer(n));
        }
        if (bl) {
            this.setReadWriteByNio();
        } else {
            this.setWritable();
        }
    }

    protected void setWritable() {
        this.selKeyReqFlags = 5;
        Tl1TunnelFactory.instance().selectCallback(this);
    }

    protected void setReadOnlyByNio() {
        this.selKeyReqFlags = 0;
        this.selKey.interestOps(1);
    }

    protected void setReadWriteByNio() {
        this.selKeyReqFlags = 0;
        this.selKey.interestOps(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectCallback() {
        if (this.state == CLOSING) {
            try {
                if (this.selKey != null) {
                    this.selKey.cancel();
                    this.selKey = null;
                }
                if (!this.socket.isClosed()) {
                    this.socket.close();
                    this.channel.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            Tl1Tunnel tl1Tunnel = this;
            synchronized (tl1Tunnel) {
                this.notifyAll();
            }
            if (this.closedByUser || this.wfActUserReply) {
                Tl1TunnelFactory.instance().removeTl1Tunnel(this);
                this.setState(CLOSED);
                if (this.wfActUserReply) {
                    dbg.println("waking up open tunnel thread (skt closed)");
                    tl1Tunnel = this;
                    synchronized (tl1Tunnel) {
                        this.notifyAll();
                    }
                }
            } else {
                this.setState(RETRYPENDING);
                new TunnelReOpener().start();
            }
        } else {
            if (this.selKey == null) {
                try {
                    this.selKey = this.channel.register(this.selector, 1, this);
                }
                catch (ClosedChannelException closedChannelException) {
                    closedChannelException.printStackTrace();
                }
            }
            if (this.selKeyReqFlags != 0) {
                this.selKey.interestOps(this.selKeyReqFlags);
                this.selKeyReqFlags = 0;
            }
            if (!this.channel.isOpen()) {
                this.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processWrite() {
        block15: {
            try {
                Object object;
                this.setReadOnlyByNio();
                if (this.tl1Buffer.isOutBufferLoaded() && !this.tl1Buffer.resendOutBuffer()) {
                    return;
                }
                this.muxbb.clear();
                this.muxbb.limit(this.maxTxPayloadSize);
                int n = this.rrIndex;
                int n2 = 0;
                int n3 = n;
                do {
                    if ((object = this.channels[n3]) != null) {
                        int n4 = ((SotSocketImpl)object).collectSendPdus(this.muxbb);
                        if (n4 == -1) {
                            this.rrIndex = n3;
                            break;
                        }
                        n2 += n4;
                    }
                    if (++n3 != this.channels.length) continue;
                    n3 = 0;
                } while (n3 != n);
                if (n2 > maxmux) {
                    maxmux = n2;
                    if (dbg.on()) {
                        dbg.println("Max Mux=" + maxmux);
                    }
                }
                this.muxbb.flip();
                if (this.muxbb.hasRemaining()) {
                    this.tl1Buffer.loadOutBuffer(this.muxbb);
                    this.tl1Buffer.resendOutBuffer();
                    this.setReadWriteByNio();
                    break block15;
                }
                if (!this.closeRqPending.isEmpty()) {
                    Integer n5;
                    this.muxbb.clear();
                    object = this.closeRqPending;
                    synchronized (object) {
                        n5 = (Integer)this.closeRqPending.removeFirst();
                    }
                    Ssh.chnCloseRq(this.muxbb, 0, n5);
                    this.muxbb.flip();
                    this.tl1Buffer.loadOutBuffer(this.muxbb, this.address.isDataBase64());
                    this.tl1Buffer.resendOutBuffer();
                    this.setReadWriteByNio();
                    break block15;
                }
                if (this.nextPayloadProbeSize > 0) {
                    this.muxbb.clear();
                    Ssh.chnDataEchoRq(this.muxbb, -320017172, (byte)0, this.nextPayloadProbeSize);
                    this.muxbb.flip();
                    this.nextPayloadProbeSize = 0;
                    this.tl1Buffer.loadOutBuffer(this.muxbb, this.address.isDataBase64());
                    if (!this.tl1Buffer.resendOutBuffer()) {
                        this.setReadWriteByNio();
                    }
                }
            }
            catch (IOException iOException) {
                KDebug.printStackTrace(iOException);
                this.lastIoExc = iOException;
                this.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRead() {
        block9: {
            try {
                boolean bl = this.tl1Buffer.readInBuffer(this.muxbb);
                if (bl) {
                    int n = 0;
                    while (this.muxbb.hasRemaining()) {
                        n += Ssh.decode(this, this.muxbb);
                    }
                    if (n > 0) {
                        this.addRx(n);
                    }
                    break block9;
                }
                String string = NioBufferHelper.toString(this.muxbb);
                this.traceActivity(string);
                if (!this.wfActUserReply || string.indexOf("COMPLD") < 0 && string.indexOf("DENY") < 0) break block9;
                this.actUserReply = string;
                this.wfActUserReply = false;
                Tl1Tunnel tl1Tunnel = this;
                synchronized (tl1Tunnel) {
                    this.notifyAll();
                }
            }
            catch (IOException iOException) {
                this.lastIoExc = iOException;
                KDebug.printStackTrace(iOException);
                this.dispose();
            }
            catch (Exception exception) {
                KDebug.printStackTrace(exception);
                this.dispose();
            }
        }
    }

    private void traceActivity(String string) {
        if (dbg.on()) {
            dbg.println(string);
        }
        this.setChanged();
        this.notifyObservers(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void chnOpenConf(int n, int n2, int n3, int n4) throws ClosedChannelException, IOException {
        if (n == 0 || n == -1) {
            byte[] byArray = new byte[]{(byte)(n2 >> 24 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)};
            try {
                this.pneIp = InetAddress.getByAddress(byArray);
            }
            catch (UnknownHostException unknownHostException) {
                unknownHostException.printStackTrace();
            }
            this.setState(OPEN);
            Tl1Tunnel tl1Tunnel = this;
            synchronized (tl1Tunnel) {
                this.notifyAll();
            }
        }
        SotSocketImpl sotSocketImpl = this.getSocket(n);
        if (sotSocketImpl != null) {
            sotSocketImpl.chnOpenConf(n2, n3, n4);
        } else {
            this.sendChnClose(n2, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void chnOpenFail(int n, int n2, String string) {
        if (n == 0) {
            Tl1Tunnel tl1Tunnel = this;
            synchronized (tl1Tunnel) {
                this.setState(OPENFAILED);
                this.failDesc = string.length() == 0 ? "Unspecified reason" : string;
                this.notify();
            }
        } else {
            SotSocketImpl sotSocketImpl = this.getSocket(n);
            if (sotSocketImpl != null) {
                sotSocketImpl.chnOpenFail(n2, string);
            }
        }
    }

    protected void chnWndAdjust(int n, int n2) throws ClosedChannelException, IOException {
        SotSocketImpl sotSocketImpl = this.getSocket(n);
        if (sotSocketImpl != null) {
            sotSocketImpl.chnWndAdjust(n2);
        }
    }

    protected void chnData(int n, int n2, ByteBuffer byteBuffer) {
        SotSocketImpl sotSocketImpl = this.getSocket(n);
        if (sotSocketImpl != null) {
            sotSocketImpl.chnData(n2, byteBuffer);
        } else {
            byteBuffer.position(byteBuffer.position() + n2);
            if (n == -320017172) {
                n2 += 9;
                if (dbg.on()) {
                    dbg.println("Tx Payload Size probe echoed back len=" + n2);
                }
                if (n2 > this.maxTxPayloadSize) {
                    this.maxTxPayloadSize = n2;
                    if ((n2 += 256) <= this.muxbb.capacity()) {
                        this.nextPayloadProbeSize = n2;
                        this.setReadWriteByNio();
                    }
                }
            }
        }
    }

    protected void chnClose(int n) {
        SotSocketImpl sotSocketImpl = this.getSocket(n);
        if (sotSocketImpl == null) {
            if (n == -1) {
                dbg.println("Tunnel Reset Requested by PNE");
                this.dispose();
            }
        } else {
            sotSocketImpl.chnClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SotSocketImpl getStaleSocket(int n) {
        SotSocketImpl[] sotSocketImplArray = this.channels;
        synchronized (this.channels) {
            for (int i = 0; i < this.channels.length; ++i) {
                if (this.channels[i] == null || this.channels[i].getRemChnId() != n) continue;
                if (dbg.on()) {
                    dbg.println("Found stale context PNE ID=" + Integer.toHexString(n));
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.channels[i];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        dbg.println("--- TUNNEL " + this.address);
        dbg.println("ST=" + this.state + " Tot created sockets=" + this.totSockCount + " Rx=" + this.rxBytes + " Tx=" + this.txBytes + " retries=" + this.retries + " txSize=" + this.maxTxPayloadSize);
        SotSocketImpl[] sotSocketImplArray = this.channels;
        synchronized (this.channels) {
            for (int i = 0; i < this.channels.length; ++i) {
                if (this.channels[i] == null) continue;
                SotSocketImpl sotSocketImpl = this.channels[i];
                sotSocketImpl.dump();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStats() {
        Tl1Tunnel tl1Tunnel = this;
        synchronized (tl1Tunnel) {
            this.rxBytes = 0L;
            this.txBytes = 0L;
            this.retries = 0;
        }
        this.sendUpdates();
    }

    private void setState(TtState ttState) {
        if (dbg.on()) {
            dbg.println("State change " + this.state + "->" + ttState);
        }
        this.state = ttState;
        this.sendUpdates();
    }

    public TtState getState() {
        return this.state;
    }

    public int getRetries() {
        return this.retries;
    }

    public int getSocketCount() {
        return this.nbChannels;
    }

    public long getRx() {
        return this.rxBytes;
    }

    public long getTx() {
        return this.txBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRx(int n) {
        Tl1Tunnel tl1Tunnel = this;
        synchronized (tl1Tunnel) {
            this.rxBytes += (long)n;
        }
        this.sendUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTx(int n) {
        Tl1Tunnel tl1Tunnel = this;
        synchronized (tl1Tunnel) {
            this.txBytes += (long)n;
        }
        this.sendUpdates();
    }

    private void sendUpdates() {
        this.setChanged();
        this.notifyObservers();
    }

    static {
        NOTINITED = new TtState("NOT INITED");
        OPENING = new TtState("OPENING");
        OPEN = new TtState("OPEN");
        OPENFAILED = new TtState("OPEN FAILED");
        CLOSING = new TtState("CLOSING");
        RETRYPENDING = new TtState("RETRY PENDING");
        CLOSED = new TtState("CLOSED");
    }

    public static class TtState {
        private String name;

        TtState(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }

    private class TunnelReOpener
    extends Thread {
        TunnelReOpener() {
            super("SoTL1 Tunnel ReOpener:" + ((Tl1Tunnel)Tl1Tunnel.this).address.host + "/" + ((Tl1Tunnel)Tl1Tunnel.this).address.pneTid);
        }

        public void run() {
            int n = 2000;
            while (Tl1Tunnel.this.state == RETRYPENDING) {
                try {
                    Thread.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (Tl1Tunnel.this.state != RETRYPENDING) continue;
                try {
                    if (dbg.on()) {
                        dbg.println("Reopening tunnel:" + this.getName());
                    }
                    ++Tl1Tunnel.this.retries;
                    Tl1Tunnel.this.sendUpdates();
                    Tl1Tunnel.this.openTunnel(true);
                }
                catch (IOException iOException) {
                    dbg;
                    KDebug.printStackTrace(iOException);
                }
                n = 20000;
            }
            if (dbg.on()) {
                dbg.println("Exiting thread:" + this.getName());
            }
        }
    }
}

